/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.impl.networking.client.ClientConfigurationNetworkAddon;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.client.accessor.ClientCommonNetworkHandlerAccessor;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8674;
import net.minecraft.class_8706;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientConfigurationNetworking {
    public static boolean registerGlobalReceiver(class_2960 channelName, ConfigurationChannelHandler channelHandler) {
        return ClientNetworkingImpl.CONFIGURATION.registerGlobalReceiver(channelName, channelHandler);
    }

    public static <T extends FabricPacket> boolean registerGlobalReceiver(final PacketType<T> type, final ConfigurationPacketHandler<T> handler) {
        return ClientConfigurationNetworking.registerGlobalReceiver(type.getId(), new ConfigurationChannelHandlerProxy<T>(){

            @Override
            public ConfigurationPacketHandler<T> getOriginalHandler() {
                return handler;
            }

            @Override
            public void receive(class_310 client, class_8674 networkHandler, class_2540 buf, PacketSender sender) {
                Object packet = type.read(buf);
                if (client.method_18854()) {
                    handler.receive(packet, sender);
                } else {
                    client.execute(() -> {
                        if (((ClientCommonNetworkHandlerAccessor)networkHandler).getConnection().method_10758()) {
                            handler.receive(packet, sender);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public static ConfigurationChannelHandler unregisterGlobalReceiver(class_2960 channelName) {
        return ClientNetworkingImpl.CONFIGURATION.unregisterGlobalReceiver(channelName);
    }

    @Nullable
    public static <T extends FabricPacket> ConfigurationPacketHandler<T> unregisterGlobalReceiver(PacketType<T> type) {
        ConfigurationPacketHandler configurationPacketHandler;
        ConfigurationChannelHandler handler = ClientNetworkingImpl.CONFIGURATION.unregisterGlobalReceiver(type.getId());
        if (handler instanceof ConfigurationChannelHandlerProxy) {
            ConfigurationChannelHandlerProxy proxy = (ConfigurationChannelHandlerProxy)handler;
            configurationPacketHandler = proxy.getOriginalHandler();
        } else {
            configurationPacketHandler = null;
        }
        return configurationPacketHandler;
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ClientNetworkingImpl.CONFIGURATION.getChannels();
    }

    public static boolean registerReceiver(class_2960 channelName, ConfigurationChannelHandler channelHandler) {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.registerChannel(channelName, channelHandler);
        }
        throw new IllegalStateException("Cannot register receiver while not configuring!");
    }

    public static <T extends FabricPacket> boolean registerReceiver(final PacketType<T> type, final ConfigurationPacketHandler<T> handler) {
        return ClientConfigurationNetworking.registerReceiver(type.getId(), new ConfigurationChannelHandlerProxy<T>(){

            @Override
            public ConfigurationPacketHandler<T> getOriginalHandler() {
                return handler;
            }

            @Override
            public void receive(class_310 client, class_8674 networkHandler, class_2540 buf, PacketSender sender) {
                Object packet = type.read(buf);
                if (client.method_18854()) {
                    handler.receive(packet, sender);
                } else {
                    client.execute(() -> {
                        if (((ClientCommonNetworkHandlerAccessor)networkHandler).getConnection().method_10758()) {
                            handler.receive(packet, sender);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public static ConfigurationChannelHandler unregisterReceiver(class_2960 channelName) throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return (ConfigurationChannelHandler)addon.unregisterChannel(channelName);
        }
        throw new IllegalStateException("Cannot unregister receiver while not configuring!");
    }

    @Nullable
    public static <T extends FabricPacket> ConfigurationPacketHandler<T> unregisterReceiver(PacketType<T> type) {
        ConfigurationPacketHandler configurationPacketHandler;
        ConfigurationChannelHandler handler = ClientConfigurationNetworking.unregisterReceiver(type.getId());
        if (handler instanceof ConfigurationChannelHandlerProxy) {
            ConfigurationChannelHandlerProxy proxy = (ConfigurationChannelHandlerProxy)handler;
            configurationPacketHandler = proxy.getOriginalHandler();
        } else {
            configurationPacketHandler = null;
        }
        return configurationPacketHandler;
    }

    public static Set<class_2960> getReceived() throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.getReceivableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the client can receive packets on while not configuring!");
    }

    public static Set<class_2960> getSendable() throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.getSendableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not configuring!");
    }

    public static boolean canSend(class_2960 channelName) throws IllegalArgumentException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.getSendableChannels().contains(channelName);
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not configuring!");
    }

    public static boolean canSend(PacketType<?> type) {
        return ClientConfigurationNetworking.canSend(type.getId());
    }

    public static class_2596<class_8706> createC2SPacket(class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ClientNetworkingImpl.createC2SPacket(channelName, buf);
    }

    public static PacketSender getSender() throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon;
        }
        throw new IllegalStateException("Cannot get PacketSender while not configuring!");
    }

    public static void send(class_2960 channelName, class_2540 buf) throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            addon.sendPacket(ClientConfigurationNetworking.createC2SPacket(channelName, buf));
            return;
        }
        throw new IllegalStateException("Cannot send packet while not configuring!");
    }

    public static <T extends FabricPacket> void send(T packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            addon.sendPacket(packet);
            return;
        }
        throw new IllegalStateException("Cannot send packet while not configuring!");
    }

    private ClientConfigurationNetworking() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ConfigurationPacketHandler<T extends FabricPacket> {
        public void receive(T var1, PacketSender var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ConfigurationChannelHandler {
        public void receive(class_310 var1, class_8674 var2, class_2540 var3, PacketSender var4);
    }

    @Environment(value=EnvType.CLIENT)
    private static interface ConfigurationChannelHandlerProxy<T extends FabricPacket>
    extends ConfigurationChannelHandler {
        public ConfigurationPacketHandler<T> getOriginalHandler();
    }
}

