/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking;

import io.netty.util.AsciiString;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.AbstractNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.CommonPacketHandler;
import net.fabricmc.fabric.impl.networking.CommonRegisterPayload;
import net.fabricmc.fabric.impl.networking.GenericFutureListenerHolder;
import net.fabricmc.fabric.impl.networking.GlobalReceiverRegistry;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.minecraft.class_151;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_7648;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChanneledNetworkAddon<H>
extends AbstractNetworkAddon<H>
implements PacketSender,
CommonPacketHandler {
    protected final class_2535 connection;
    protected final GlobalReceiverRegistry<H> receiver;
    protected final Set<class_2960> sendableChannels;
    protected int commonVersion = -1;

    protected AbstractChanneledNetworkAddon(GlobalReceiverRegistry<H> receiver, class_2535 connection, String description) {
        super(receiver, description);
        this.connection = connection;
        this.receiver = receiver;
        this.sendableChannels = Collections.synchronizedSet(new HashSet());
    }

    public abstract void lateInit();

    protected void registerPendingChannels(ChannelInfoHolder holder, class_2539 state) {
        Collection<class_2960> pending = holder.getPendingChannelsNames(state);
        if (!pending.isEmpty()) {
            this.register(new ArrayList<class_2960>(pending));
            pending.clear();
        }
    }

    protected boolean handle(class_2960 channelName, class_2540 buf) {
        this.logger.debug("Handling inbound packet from channel with name \"{}\"", (Object)channelName);
        if (NetworkingImpl.REGISTER_CHANNEL.equals((Object)channelName)) {
            this.receiveRegistration(true, buf);
            return true;
        }
        if (NetworkingImpl.UNREGISTER_CHANNEL.equals((Object)channelName)) {
            this.receiveRegistration(false, buf);
            return true;
        }
        @Nullable H handler = this.getHandler(channelName);
        if (handler == null) {
            return false;
        }
        try {
            this.receive(handler, buf);
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel with name \"{}\"", (Object)channelName, (Object)ex);
            throw ex;
        }
        return true;
    }

    protected abstract void receive(H var1, class_2540 var2);

    protected void sendInitialChannelRegistrationPacket() {
        class_2540 buf = this.createRegistrationPacket(this.getReceivableChannels());
        if (buf != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    @Nullable
    protected class_2540 createRegistrationPacket(Collection<class_2960> channels) {
        if (channels.isEmpty()) {
            return null;
        }
        class_2540 buf = PacketByteBufs.create();
        boolean first = true;
        for (class_2960 channel : channels) {
            if (first) {
                first = false;
            } else {
                buf.method_52997(0);
            }
            buf.method_52983(channel.toString().getBytes(StandardCharsets.US_ASCII));
        }
        return buf;
    }

    protected void receiveRegistration(boolean register, class_2540 buf) {
        ArrayList<class_2960> ids = new ArrayList<class_2960>();
        StringBuilder active = new StringBuilder();
        while (buf.isReadable()) {
            byte b = buf.readByte();
            if (b != 0) {
                active.append(AsciiString.b2c((byte)b));
                continue;
            }
            this.addId(ids, active);
            active = new StringBuilder();
        }
        this.addId(ids, active);
        if (register) {
            this.register(ids);
        } else {
            this.unregister(ids);
        }
    }

    void register(List<class_2960> ids) {
        this.sendableChannels.addAll(ids);
        this.schedule(() -> this.invokeRegisterEvent(ids));
    }

    void unregister(List<class_2960> ids) {
        this.sendableChannels.removeAll(ids);
        this.schedule(() -> this.invokeUnregisterEvent(ids));
    }

    @Override
    public void sendPacket(class_2596<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        this.sendPacket(packet, (class_7648)GenericFutureListenerHolder.create(callback));
    }

    @Override
    public void sendPacket(class_2596<?> packet, class_7648 callback) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.method_10752(packet, callback);
    }

    protected abstract void schedule(Runnable var1);

    protected abstract void invokeRegisterEvent(List<class_2960> var1);

    protected abstract void invokeUnregisterEvent(List<class_2960> var1);

    private void addId(List<class_2960> ids, StringBuilder sb) {
        String literal = sb.toString();
        try {
            ids.add(new class_2960(literal));
        }
        catch (class_151 ex) {
            this.logger.warn("Received invalid channel identifier \"{}\" from connection {}", (Object)literal, (Object)this.connection);
        }
    }

    public Set<class_2960> getSendableChannels() {
        return Collections.unmodifiableSet(this.sendableChannels);
    }

    @Override
    public void onCommonVersionPacket(int negotiatedVersion) {
        assert (negotiatedVersion == 1);
        this.commonVersion = negotiatedVersion;
        this.logger.info("Negotiated common packet version {}", (Object)this.commonVersion);
    }

    @Override
    public void onCommonRegisterPacket(CommonRegisterPayload payload) {
        if (payload.version() != this.getNegotiatedVersion()) {
            throw new IllegalStateException("Negotiated common packet version: %d but received packet with version: %d".formatted(this.commonVersion, payload.version()));
        }
        String currentPhase = this.getPhase();
        if (currentPhase == null) {
            this.logger.warn("Received common register packet for phase {} in network state: {}", (Object)payload.phase(), (Object)this.receiver.getState());
            return;
        }
        if (!payload.phase().equals(currentPhase)) {
            throw new IllegalStateException("Register packet received for phase (%s) on handler for phase(%s)".formatted(payload.phase(), currentPhase));
        }
        this.register(new ArrayList<class_2960>(payload.channels()));
    }

    @Override
    public CommonRegisterPayload createRegisterPayload() {
        return new CommonRegisterPayload(this.getNegotiatedVersion(), this.getPhase(), this.getReceivableChannels());
    }

    @Override
    public int getNegotiatedVersion() {
        if (this.commonVersion == -1) {
            throw new IllegalStateException("Not yet negotiated common packet version");
        }
        return this.commonVersion;
    }

    @Nullable
    private String getPhase() {
        return switch (this.receiver.getState()) {
            case class_2539.field_20591 -> "play";
            case class_2539.field_45671 -> "configuration";
            default -> null;
        };
    }
}

