/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.client;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.CommonPacketsImpl;
import net.fabricmc.fabric.impl.networking.CommonRegisterPayload;
import net.fabricmc.fabric.impl.networking.CommonVersionPayload;
import net.fabricmc.fabric.impl.networking.GlobalReceiverRegistry;
import net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.client.ClientConfigurationNetworkAddon;
import net.fabricmc.fabric.impl.networking.client.ClientLoginNetworkAddon;
import net.fabricmc.fabric.impl.networking.client.ClientPlayNetworkAddon;
import net.fabricmc.fabric.impl.networking.payload.PacketByteBufPayload;
import net.fabricmc.fabric.mixin.networking.client.accessor.ConnectScreenAccessor;
import net.fabricmc.fabric.mixin.networking.client.accessor.MinecraftClientAccessor;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_634;
import net.minecraft.class_635;
import net.minecraft.class_8674;
import net.minecraft.class_8706;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientNetworkingImpl {
    public static final GlobalReceiverRegistry<ClientLoginNetworking.LoginQueryRequestHandler> LOGIN = new GlobalReceiverRegistry(class_2539.field_20593);
    public static final GlobalReceiverRegistry<ClientConfigurationNetworking.ConfigurationChannelHandler> CONFIGURATION = new GlobalReceiverRegistry(class_2539.field_45671);
    public static final GlobalReceiverRegistry<ClientPlayNetworking.PlayChannelHandler> PLAY = new GlobalReceiverRegistry(class_2539.field_20591);
    private static ClientPlayNetworkAddon currentPlayAddon;
    private static ClientConfigurationNetworkAddon currentConfigurationAddon;

    public static ClientPlayNetworkAddon getAddon(class_634 handler) {
        return (ClientPlayNetworkAddon)((NetworkHandlerExtensions)handler).getAddon();
    }

    public static ClientConfigurationNetworkAddon getAddon(class_8674 handler) {
        return (ClientConfigurationNetworkAddon)((NetworkHandlerExtensions)handler).getAddon();
    }

    public static ClientLoginNetworkAddon getAddon(class_635 handler) {
        return (ClientLoginNetworkAddon)((NetworkHandlerExtensions)handler).getAddon();
    }

    public static class_2596<class_8706> createC2SPacket(class_2960 channelName, class_2540 buf) {
        return new class_2817((class_8710)new PacketByteBufPayload(channelName, buf));
    }

    public static class_2596<class_8706> createC2SPacket(FabricPacket packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        class_2540 buf = PacketByteBufs.create();
        packet.write(buf);
        return ClientNetworkingImpl.createC2SPacket(packet.getType().getId(), buf);
    }

    @Nullable
    public static class_2535 getLoginConnection() {
        class_2535 connection = ((MinecraftClientAccessor)class_310.method_1551()).getConnection();
        if (connection != null) {
            return connection;
        }
        if (class_310.method_1551().field_1755 instanceof class_412) {
            return ((ConnectScreenAccessor)class_310.method_1551().field_1755).getConnection();
        }
        return null;
    }

    @Nullable
    public static ClientConfigurationNetworkAddon getClientConfigurationAddon() {
        return currentConfigurationAddon;
    }

    @Nullable
    public static ClientPlayNetworkAddon getClientPlayAddon() {
        if (class_310.method_1551().method_1562() != null) {
            currentPlayAddon = null;
            return ClientNetworkingImpl.getAddon(class_310.method_1551().method_1562());
        }
        if (currentPlayAddon != null) {
            return currentPlayAddon;
        }
        return null;
    }

    public static void setClientPlayAddon(ClientPlayNetworkAddon addon) {
        assert (addon == null || currentConfigurationAddon == null);
        currentPlayAddon = addon;
    }

    public static void setClientConfigurationAddon(ClientConfigurationNetworkAddon addon) {
        assert (addon == null || currentPlayAddon == null);
        currentConfigurationAddon = addon;
    }

    public static void clientInit() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            currentPlayAddon = null;
        });
        ClientConfigurationConnectionEvents.DISCONNECT.register((handler, client) -> {
            currentConfigurationAddon = null;
        });
        ClientConfigurationNetworking.registerGlobalReceiver(CommonVersionPayload.PACKET_ID, (client, handler, buf, responseSender) -> {
            CommonVersionPayload payload = new CommonVersionPayload(buf);
            int negotiatedVersion = ClientNetworkingImpl.handleVersionPacket(payload, responseSender);
            ClientNetworkingImpl.getAddon(handler).onCommonVersionPacket(negotiatedVersion);
        });
        ClientConfigurationNetworking.registerGlobalReceiver(CommonRegisterPayload.PACKET_ID, (client, handler, buf, responseSender) -> {
            CommonRegisterPayload payload = new CommonRegisterPayload(buf);
            ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getAddon(handler);
            if ("play".equals(payload.phase())) {
                if (payload.version() != addon.getNegotiatedVersion()) {
                    throw new IllegalStateException("Negotiated common packet version: %d but received packet with version: %d".formatted(addon.getNegotiatedVersion(), payload.version()));
                }
                addon.getChannelInfoHolder().getPendingChannelsNames(class_2539.field_20591).addAll(payload.channels());
                NetworkingImpl.LOGGER.debug("Received accepted channels from the server");
                responseSender.sendPacket(new CommonRegisterPayload(addon.getNegotiatedVersion(), "play", ClientPlayNetworking.getGlobalReceivers()));
            } else {
                addon.onCommonRegisterPacket(payload);
                responseSender.sendPacket(addon.createRegisterPayload());
            }
        });
    }

    private static int handleVersionPacket(CommonVersionPayload payload, PacketSender packetSender) {
        int version = CommonPacketsImpl.getHighestCommonVersion(payload.versions(), CommonPacketsImpl.SUPPORTED_COMMON_PACKET_VERSIONS);
        if (version <= 0) {
            throw new UnsupportedOperationException("Client does not support any requested versions from server");
        }
        packetSender.sendPacket(new CommonVersionPayload(new int[]{version}));
        return version;
    }
}

