/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.server;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.S2CConfigurationChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.payload.PacketByteBufPayload;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonNetworkHandlerAccessor;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_6373;
import net.minecraft.class_7648;
import net.minecraft.class_8610;
import net.minecraft.server.MinecraftServer;

public final class ServerConfigurationNetworkAddon
extends AbstractChanneledNetworkAddon<ServerConfigurationNetworking.ConfigurationChannelHandler> {
    private final class_8610 handler;
    private final MinecraftServer server;
    private RegisterState registerState = RegisterState.NOT_SENT;

    public ServerConfigurationNetworkAddon(class_8610 handler, MinecraftServer server) {
        super(ServerNetworkingImpl.CONFIGURATION, ((ServerCommonNetworkHandlerAccessor)handler).getConnection(), "ServerConfigurationNetworkAddon for " + handler.method_52404().getName());
        this.handler = handler;
        this.server = server;
        this.registerPendingChannels((ChannelInfoHolder)this.connection, class_2539.field_45671);
        this.receiver.startSession(this);
    }

    @Override
    public void lateInit() {
        for (Map.Entry entry : this.receiver.getHandlers().entrySet()) {
            this.registerChannel(entry.getKey(), (ServerConfigurationNetworking.ConfigurationChannelHandler)entry.getValue());
        }
    }

    public void preConfiguration() {
        ((ServerConfigurationConnectionEvents.Configure)ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.invoker()).onSendConfiguration(this.handler, this.server);
    }

    public void configuration() {
        ((ServerConfigurationConnectionEvents.Configure)ServerConfigurationConnectionEvents.CONFIGURE.invoker()).onSendConfiguration(this.handler, this.server);
    }

    public boolean startConfiguration() {
        if (this.registerState == RegisterState.NOT_SENT) {
            this.sendInitialChannelRegistrationPacket();
            this.sendPacket(new class_6373(16430876));
            this.registerState = RegisterState.SENT;
            return true;
        }
        assert (this.registerState == RegisterState.RECEIVED || this.registerState == RegisterState.NOT_RECEIVED);
        return false;
    }

    @Override
    protected void receiveRegistration(boolean register, class_2540 buf) {
        super.receiveRegistration(register, buf);
        if (register && this.registerState == RegisterState.SENT) {
            this.registerState = RegisterState.RECEIVED;
            this.handler.method_52409();
        }
    }

    public void onPong(int parameter) {
        if (this.registerState == RegisterState.SENT) {
            this.registerState = RegisterState.NOT_RECEIVED;
            this.handler.method_52409();
        }
    }

    public boolean handle(PacketByteBufPayload payload) {
        return this.handle(payload.comp_1678(), payload.data());
    }

    @Override
    protected void receive(ServerConfigurationNetworking.ConfigurationChannelHandler handler, class_2540 buf) {
        handler.receive(this.server, this.handler, buf, this);
    }

    @Override
    protected void schedule(Runnable task) {
        this.server.execute(task);
    }

    @Override
    public class_2596<?> createPacket(class_2960 channelName, class_2540 buf) {
        return ServerPlayNetworking.createS2CPacket(channelName, buf);
    }

    @Override
    public class_2596<?> createPacket(FabricPacket packet) {
        return ServerPlayNetworking.createS2CPacket(packet);
    }

    @Override
    protected void invokeRegisterEvent(List<class_2960> ids) {
        ((S2CConfigurationChannelEvents.Register)S2CConfigurationChannelEvents.REGISTER.invoker()).onChannelRegister(this.handler, this, this.server, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<class_2960> ids) {
        ((S2CConfigurationChannelEvents.Unregister)S2CConfigurationChannelEvents.UNREGISTER.invoker()).onChannelUnregister(this.handler, this, this.server, ids);
    }

    @Override
    protected void handleRegistration(class_2960 channelName) {
        class_2540 buf;
        if (this.registerState != RegisterState.NOT_SENT && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void handleUnregistration(class_2960 channelName) {
        class_2540 buf;
        if (this.registerState != RegisterState.NOT_SENT && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.UNREGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ServerConfigurationConnectionEvents.Disconnect)ServerConfigurationConnectionEvents.DISCONNECT.invoker()).onConfigureDisconnect(this.handler, this.server);
        this.receiver.endSession(this);
    }

    @Override
    protected boolean isReservedChannel(class_2960 channelName) {
        return NetworkingImpl.isReservedCommonChannel(channelName);
    }

    @Override
    public void sendPacket(class_2596<?> packet, class_7648 callback) {
        this.handler.method_52391(packet, callback);
    }

    public ChannelInfoHolder getChannelInfoHolder() {
        return (ChannelInfoHolder)((ServerCommonNetworkHandlerAccessor)this.handler).getConnection();
    }

    private static enum RegisterState {
        NOT_SENT,
        SENT,
        RECEIVED,
        NOT_RECEIVED;

    }
}

