/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.impl.networking.client.ClientConfigurationNetworkAddon;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.impl.networking.payload.ResolvablePayload;
import net.fabricmc.fabric.impl.networking.payload.TypedPayload;
import net.fabricmc.fabric.impl.networking.payload.UntypedPayload;
import net.fabricmc.fabric.mixin.networking.client.accessor.ClientCommonNetworkHandlerAccessor;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8674;
import net.minecraft.class_8706;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientConfigurationNetworking {
    public static boolean registerGlobalReceiver(class_2960 channelName, ConfigurationChannelHandler channelHandler) {
        return ClientNetworkingImpl.CONFIGURATION.registerGlobalReceiver(channelName, ClientConfigurationNetworking.wrapUntyped(channelHandler));
    }

    public static <T extends FabricPacket> boolean registerGlobalReceiver(PacketType<T> type, ConfigurationPacketHandler<T> handler) {
        return ClientNetworkingImpl.CONFIGURATION.registerGlobalReceiver(type.getId(), ClientConfigurationNetworking.wrapTyped(type, handler));
    }

    @Nullable
    public static ConfigurationChannelHandler unregisterGlobalReceiver(class_2960 channelName) {
        return ClientConfigurationNetworking.unwrapUntyped(ClientNetworkingImpl.CONFIGURATION.unregisterGlobalReceiver(channelName));
    }

    @Nullable
    public static <T extends FabricPacket> ConfigurationPacketHandler<T> unregisterGlobalReceiver(PacketType<T> type) {
        return ClientConfigurationNetworking.unwrapTyped(ClientNetworkingImpl.CONFIGURATION.unregisterGlobalReceiver(type.getId()));
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ClientNetworkingImpl.CONFIGURATION.getChannels();
    }

    public static boolean registerReceiver(class_2960 channelName, ConfigurationChannelHandler channelHandler) {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.registerChannel(channelName, ClientConfigurationNetworking.wrapUntyped(channelHandler));
        }
        throw new IllegalStateException("Cannot register receiver while not configuring!");
    }

    public static <T extends FabricPacket> boolean registerReceiver(PacketType<T> type, ConfigurationPacketHandler<T> handler) {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.registerChannel(type.getId(), ClientConfigurationNetworking.wrapTyped(type, handler));
        }
        throw new IllegalStateException("Cannot register receiver while not configuring!");
    }

    @Nullable
    public static ConfigurationChannelHandler unregisterReceiver(class_2960 channelName) throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return ClientConfigurationNetworking.unwrapUntyped((ResolvablePayload.Handler)addon.unregisterChannel(channelName));
        }
        throw new IllegalStateException("Cannot unregister receiver while not configuring!");
    }

    @Nullable
    public static <T extends FabricPacket> ConfigurationPacketHandler<T> unregisterReceiver(PacketType<T> type) {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return ClientConfigurationNetworking.unwrapTyped((ResolvablePayload.Handler)addon.unregisterChannel(type.getId()));
        }
        throw new IllegalStateException("Cannot unregister receiver while not configuring!");
    }

    public static Set<class_2960> getReceived() throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.getReceivableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the client can receive packets on while not configuring!");
    }

    public static Set<class_2960> getSendable() throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.getSendableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not configuring!");
    }

    public static boolean canSend(class_2960 channelName) throws IllegalArgumentException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.getSendableChannels().contains(channelName);
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not configuring!");
    }

    public static boolean canSend(PacketType<?> type) {
        return ClientConfigurationNetworking.canSend(type.getId());
    }

    public static class_2596<class_8706> createC2SPacket(class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ClientNetworkingImpl.createC2SPacket(channelName, buf);
    }

    public static PacketSender getSender() throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon;
        }
        throw new IllegalStateException("Cannot get PacketSender while not configuring!");
    }

    public static void send(class_2960 channelName, class_2540 buf) throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            addon.sendPacket(ClientConfigurationNetworking.createC2SPacket(channelName, buf));
            return;
        }
        throw new IllegalStateException("Cannot send packet while not configuring!");
    }

    public static <T extends FabricPacket> void send(T packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            addon.sendPacket(packet);
            return;
        }
        throw new IllegalStateException("Cannot send packet while not configuring!");
    }

    private ClientConfigurationNetworking() {
    }

    private static ResolvablePayload.Handler<ClientConfigurationNetworkAddon.Handler> wrapUntyped(ConfigurationChannelHandler actualHandler) {
        return new ResolvablePayload.Handler<ClientConfigurationNetworkAddon.Handler>(null, actualHandler, (client, handler, payload, responseSender) -> actualHandler.receive(client, handler, ((UntypedPayload)payload).buffer(), responseSender));
    }

    private static <T extends FabricPacket> ResolvablePayload.Handler<ClientConfigurationNetworkAddon.Handler> wrapTyped(PacketType<T> type, ConfigurationPacketHandler<T> actualHandler) {
        return new ResolvablePayload.Handler<ClientConfigurationNetworkAddon.Handler>(type, actualHandler, (client, handler, payload, responseSender) -> {
            FabricPacket packet = ((TypedPayload)payload).packet();
            if (client.method_18854()) {
                actualHandler.receive(packet, responseSender);
            } else {
                client.execute(() -> {
                    if (((ClientCommonNetworkHandlerAccessor)handler).getConnection().method_10758()) {
                        actualHandler.receive(packet, responseSender);
                    }
                });
            }
        });
    }

    @Nullable
    private static ConfigurationChannelHandler unwrapUntyped(@Nullable ResolvablePayload.Handler<ClientConfigurationNetworkAddon.Handler> handler) {
        if (handler == null) {
            return null;
        }
        Object object = handler.actual();
        if (object instanceof ConfigurationChannelHandler) {
            ConfigurationChannelHandler actual = (ConfigurationChannelHandler)object;
            return actual;
        }
        return null;
    }

    @Nullable
    private static <T extends FabricPacket> ConfigurationPacketHandler<T> unwrapTyped(@Nullable ResolvablePayload.Handler<ClientConfigurationNetworkAddon.Handler> handler) {
        if (handler == null) {
            return null;
        }
        Object object = handler.actual();
        if (object instanceof ConfigurationPacketHandler) {
            ConfigurationPacketHandler actual = (ConfigurationPacketHandler)object;
            return actual;
        }
        return null;
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ConfigurationChannelHandler {
        public void receive(class_310 var1, class_8674 var2, class_2540 var3, PacketSender var4);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ConfigurationPacketHandler<T extends FabricPacket> {
        public void receive(T var1, PacketSender var2);
    }
}

