/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.impl.networking.payload.ResolvablePayload;
import net.fabricmc.fabric.impl.networking.payload.TypedPayload;
import net.fabricmc.fabric.impl.networking.payload.UntypedPayload;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.impl.networking.server.ServerPlayNetworkAddon;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8705;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class ServerPlayNetworking {
    public static boolean registerGlobalReceiver(class_2960 channelName, PlayChannelHandler channelHandler) {
        return ServerNetworkingImpl.PLAY.registerGlobalReceiver(channelName, ServerPlayNetworking.wrapUntyped(channelHandler));
    }

    public static <T extends FabricPacket> boolean registerGlobalReceiver(PacketType<T> type, PlayPacketHandler<T> handler) {
        return ServerNetworkingImpl.PLAY.registerGlobalReceiver(type.getId(), ServerPlayNetworking.wrapTyped(type, handler));
    }

    @Nullable
    public static PlayChannelHandler unregisterGlobalReceiver(class_2960 channelName) {
        return ServerPlayNetworking.unwrapUntyped(ServerNetworkingImpl.PLAY.unregisterGlobalReceiver(channelName));
    }

    @Nullable
    public static <T extends FabricPacket> PlayPacketHandler<T> unregisterGlobalReceiver(PacketType<T> type) {
        return ServerPlayNetworking.unwrapTyped(ServerNetworkingImpl.PLAY.unregisterGlobalReceiver(type.getId()));
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ServerNetworkingImpl.PLAY.getChannels();
    }

    public static boolean registerReceiver(class_3244 networkHandler, class_2960 channelName, PlayChannelHandler channelHandler) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(channelName, ServerPlayNetworking.wrapUntyped(channelHandler));
    }

    public static <T extends FabricPacket> boolean registerReceiver(class_3244 networkHandler, PacketType<T> type, PlayPacketHandler<T> handler) {
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(type.getId(), ServerPlayNetworking.wrapTyped(type, handler));
    }

    @Nullable
    public static PlayChannelHandler unregisterReceiver(class_3244 networkHandler, class_2960 channelName) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return ServerPlayNetworking.unwrapUntyped((ResolvablePayload.Handler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(channelName));
    }

    @Nullable
    public static <T extends FabricPacket> PlayPacketHandler<T> unregisterReceiver(class_3244 networkHandler, PacketType<T> type) {
        return ServerPlayNetworking.unwrapTyped((ResolvablePayload.Handler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(type.getId()));
    }

    public static Set<class_2960> getReceived(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getReceived(player.field_13987);
    }

    public static Set<class_2960> getReceived(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getReceivableChannels();
    }

    public static Set<class_2960> getSendable(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSendable(player.field_13987);
    }

    public static Set<class_2960> getSendable(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels();
    }

    public static boolean canSend(class_3222 player, class_2960 channelName) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.canSend(player.field_13987, channelName);
    }

    public static boolean canSend(class_3222 player, PacketType<?> type) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.canSend(player.field_13987, type.getId());
    }

    public static boolean canSend(class_3244 handler, class_2960 channelName) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(channelName);
    }

    public static boolean canSend(class_3244 handler, PacketType<?> type) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        Objects.requireNonNull(type, "Packet type cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(type.getId());
    }

    public static class_2596<class_8705> createS2CPacket(class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(channelName, "Channel cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ServerNetworkingImpl.createS2CPacket(channelName, buf);
    }

    public static <T extends FabricPacket> class_2596<class_8705> createS2CPacket(T packet) {
        return ServerNetworkingImpl.createS2CPacket(packet);
    }

    public static PacketSender getSender(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSender(player.field_13987);
    }

    public static PacketSender getSender(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler);
    }

    public static void send(class_3222 player, class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Packet byte buf cannot be null");
        player.field_13987.method_14364(ServerPlayNetworking.createS2CPacket(channelName, buf));
    }

    public static <T extends FabricPacket> void send(class_3222 player, T packet) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        player.field_13987.method_14364(ServerPlayNetworking.createS2CPacket(packet));
    }

    public static MinecraftServer getServer(class_3244 handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return handler.field_14140.field_13995;
    }

    private ServerPlayNetworking() {
    }

    private static ResolvablePayload.Handler<ServerPlayNetworkAddon.Handler> wrapUntyped(PlayChannelHandler actualHandler) {
        return new ResolvablePayload.Handler<ServerPlayNetworkAddon.Handler>(null, actualHandler, (server, player, handler, payload, responseSender) -> actualHandler.receive(server, player, handler, ((UntypedPayload)payload).buffer(), responseSender));
    }

    private static <T extends FabricPacket> ResolvablePayload.Handler<ServerPlayNetworkAddon.Handler> wrapTyped(PacketType<T> type, PlayPacketHandler<T> actualHandler) {
        return new ResolvablePayload.Handler<ServerPlayNetworkAddon.Handler>(type, actualHandler, (server, player, handler, payload, responseSender) -> {
            FabricPacket packet = ((TypedPayload)payload).packet();
            if (server.method_18854()) {
                actualHandler.receive(packet, player, responseSender);
            } else {
                server.execute(() -> {
                    if (handler.method_48106()) {
                        actualHandler.receive(packet, player, responseSender);
                    }
                });
            }
        });
    }

    @Nullable
    private static PlayChannelHandler unwrapUntyped(@Nullable ResolvablePayload.Handler<ServerPlayNetworkAddon.Handler> handler) {
        if (handler == null) {
            return null;
        }
        Object object = handler.actual();
        if (object instanceof PlayChannelHandler) {
            PlayChannelHandler actual = (PlayChannelHandler)object;
            return actual;
        }
        return null;
    }

    @Nullable
    private static <T extends FabricPacket> PlayPacketHandler<T> unwrapTyped(@Nullable ResolvablePayload.Handler<ServerPlayNetworkAddon.Handler> handler) {
        if (handler == null) {
            return null;
        }
        Object object = handler.actual();
        if (object instanceof PlayPacketHandler) {
            PlayPacketHandler actual = (PlayPacketHandler)object;
            return actual;
        }
        return null;
    }

    @FunctionalInterface
    public static interface PlayChannelHandler {
        public void receive(MinecraftServer var1, class_3222 var2, class_3244 var3, class_2540 var4, PacketSender var5);
    }

    @FunctionalInterface
    public static interface PlayPacketHandler<T extends FabricPacket> {
        public void receive(T var1, class_3222 var2, PacketSender var3);
    }
}

