/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.fabricmc.fabric.impl.networking.AbstractNetworkAddon;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.minecraft.class_2539;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalReceiverRegistry<H> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalReceiverRegistry.class);
    private final class_2539 state;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<class_2960, H> handlers;
    private final Set<AbstractNetworkAddon<H>> trackedAddons = new HashSet<AbstractNetworkAddon<H>>();

    public GlobalReceiverRegistry(class_2539 state) {
        this(state, new HashMap());
    }

    public GlobalReceiverRegistry(class_2539 state, Map<class_2960, H> map) {
        this.state = state;
        this.handlers = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public H getHandler(class_2960 channelName) {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            H h = this.handlers.get(channelName);
            return h;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerGlobalReceiver(class_2960 channelName, H handler) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(handler, "Channel handler cannot be null");
        if (NetworkingImpl.isReservedCommonChannel(channelName)) {
            throw new IllegalArgumentException(String.format("Cannot register handler for reserved channel with name \"%s\"", channelName));
        }
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            boolean replaced;
            boolean bl = replaced = this.handlers.putIfAbsent(channelName, handler) == null;
            if (replaced) {
                this.handleRegistration(channelName, handler);
            }
            boolean bl2 = replaced;
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public H unregisterGlobalReceiver(class_2960 channelName) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        if (NetworkingImpl.isReservedCommonChannel(channelName)) {
            throw new IllegalArgumentException(String.format("Cannot unregister packet handler for reserved channel with name \"%s\"", channelName));
        }
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            H removed = this.handlers.remove(channelName);
            if (removed != null) {
                this.handleUnregistration(channelName);
            }
            H h = removed;
            return h;
        }
        finally {
            lock.unlock();
        }
    }

    public Map<class_2960, H> getHandlers() {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            HashMap<class_2960, H> hashMap = new HashMap<class_2960, H>(this.handlers);
            return hashMap;
        }
        finally {
            lock.unlock();
        }
    }

    public Set<class_2960> getChannels() {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            HashSet<class_2960> hashSet = new HashSet<class_2960>(this.handlers.keySet());
            return hashSet;
        }
        finally {
            lock.unlock();
        }
    }

    public void startSession(AbstractNetworkAddon<H> addon) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            if (this.trackedAddons.add(addon)) {
                addon.registerChannels(this.handlers);
            }
            this.logTrackedAddonSize();
        }
        finally {
            lock.unlock();
        }
    }

    public void endSession(AbstractNetworkAddon<H> addon) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.logTrackedAddonSize();
            this.trackedAddons.remove(addon);
        }
        finally {
            lock.unlock();
        }
    }

    private void logTrackedAddonSize() {
        if (LOGGER.isTraceEnabled() && this.trackedAddons.size() > 1) {
            LOGGER.trace("{} receiver registry tracks {} addon instances", (Object)this.state.method_10785(), (Object)this.trackedAddons.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegistration(class_2960 channelName, H handler) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.logTrackedAddonSize();
            for (AbstractNetworkAddon<H> addon : this.trackedAddons) {
                addon.registerChannel(channelName, handler);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnregistration(class_2960 channelName) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.logTrackedAddonSize();
            for (AbstractNetworkAddon<H> addon : this.trackedAddons) {
                addon.unregisterChannel(channelName);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public class_2539 getState() {
        return this.state;
    }
}

