/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.client;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.impl.networking.payload.ResolvedPayload;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class ClientPlayNetworkAddon
extends AbstractChanneledNetworkAddon<Handler> {
    private final class_634 handler;
    private final class_310 client;
    private boolean sentInitialRegisterPacket;
    private static final Logger LOGGER = LogUtils.getLogger();

    public ClientPlayNetworkAddon(class_634 handler, class_310 client) {
        super(ClientNetworkingImpl.PLAY, handler.method_48296(), "ClientPlayNetworkAddon for " + handler.method_2879().getName());
        this.handler = handler;
        this.client = client;
        this.registerPendingChannels((ChannelInfoHolder)this.connection, class_2539.field_20591);
    }

    @Override
    protected void invokeInitEvent() {
        ((ClientPlayConnectionEvents.Init)ClientPlayConnectionEvents.INIT.invoker()).onPlayInit(this.handler, this.client);
    }

    public void onServerReady() {
        try {
            ((ClientPlayConnectionEvents.Join)ClientPlayConnectionEvents.JOIN.invoker()).onPlayReady(this.handler, this, this.client);
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception thrown while invoking ClientPlayConnectionEvents.JOIN", (Throwable)e);
        }
        this.sendInitialChannelRegistrationPacket();
        this.sentInitialRegisterPacket = true;
    }

    @Override
    protected void receive(Handler handler, ResolvedPayload payload) {
        handler.receive(this.client, this.handler, payload, this);
    }

    @Override
    protected void schedule(Runnable task) {
        class_310.method_1551().execute(task);
    }

    @Override
    public class_2596<?> createPacket(class_2960 channelName, class_2540 buf) {
        return ClientPlayNetworking.createC2SPacket(channelName, buf);
    }

    @Override
    public class_2596<?> createPacket(FabricPacket packet) {
        return ClientPlayNetworking.createC2SPacket(packet);
    }

    @Override
    protected void invokeRegisterEvent(List<class_2960> ids) {
        ((C2SPlayChannelEvents.Register)C2SPlayChannelEvents.REGISTER.invoker()).onChannelRegister(this.handler, this, this.client, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<class_2960> ids) {
        ((C2SPlayChannelEvents.Unregister)C2SPlayChannelEvents.UNREGISTER.invoker()).onChannelUnregister(this.handler, this, this.client, ids);
    }

    @Override
    protected void handleRegistration(class_2960 channelName) {
        class_2540 buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void handleUnregistration(class_2960 channelName) {
        class_2540 buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.UNREGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ClientPlayConnectionEvents.Disconnect)ClientPlayConnectionEvents.DISCONNECT.invoker()).onPlayDisconnect(this.handler, this.client);
    }

    @Override
    protected boolean isReservedChannel(class_2960 channelName) {
        return NetworkingImpl.isReservedCommonChannel(channelName);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface Handler {
        public void receive(class_310 var1, class_634 var2, ResolvedPayload var3, PacketSender var4);
    }
}

