/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.networking;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.DisconnectPacketSource;
import net.fabricmc.fabric.impl.networking.GenericFutureListenerHolder;
import net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions;
import net.fabricmc.fabric.impl.networking.PacketCallbackListener;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7648;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_2535.class})
abstract class ClientConnectionMixin
implements ChannelInfoHolder {
    @Shadow
    private class_2547 field_11652;
    @Unique
    private Map<class_2539, Collection<class_2960>> playChannels;

    ClientConnectionMixin() {
    }

    @Shadow
    public abstract void method_10747(class_2561 var1);

    @Shadow
    public abstract void method_10752(class_2596<?> var1, @Nullable class_7648 var2);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initAddedFields(class_2598 side, CallbackInfo ci) {
        this.playChannels = new ConcurrentHashMap<class_2539, Collection<class_2960>>();
    }

    @Redirect(method={"exceptionCaught"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/ClientConnection;send(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/PacketCallbacks;)V"))
    private void resendOnExceptionCaught(class_2535 self, class_2596<?> packet, class_7648 listener, ChannelHandlerContext context, Throwable ex) {
        class_2547 handler = this.field_11652;
        class_5250 disconnectMessage = class_2561.method_43469((String)"disconnect.genericReason", (Object[])new Object[]{"Internal Exception: " + String.valueOf(ex)});
        if (handler instanceof DisconnectPacketSource) {
            this.method_10752(((DisconnectPacketSource)handler).createDisconnectPacket((class_2561)disconnectMessage), listener);
        } else {
            this.method_10747((class_2561)disconnectMessage);
        }
    }

    @Inject(method={"sendImmediately"}, at={@At(value="FIELD", target="Lnet/minecraft/network/ClientConnection;packetsSentCounter:I")})
    private void checkPacket(class_2596<?> packet, class_7648 callback, boolean flush, CallbackInfo ci) {
        if (this.field_11652 instanceof PacketCallbackListener) {
            ((PacketCallbackListener)this.field_11652).sent(packet);
        }
    }

    @Inject(method={"setPacketListener"}, at={@At(value="HEAD")})
    private void unwatchAddon(class_2547 packetListener, CallbackInfo ci) {
        class_2547 class_25472 = this.field_11652;
        if (class_25472 instanceof NetworkHandlerExtensions) {
            NetworkHandlerExtensions oldListener = (NetworkHandlerExtensions)class_25472;
            oldListener.getAddon().endSession();
        }
    }

    @Inject(method={"channelInactive"}, at={@At(value="HEAD")})
    private void disconnectAddon(ChannelHandlerContext channelHandlerContext, CallbackInfo ci) {
        class_2547 class_25472 = this.field_11652;
        if (class_25472 instanceof NetworkHandlerExtensions) {
            NetworkHandlerExtensions extension = (NetworkHandlerExtensions)class_25472;
            extension.getAddon().handleDisconnect();
        }
    }

    @Inject(method={"handleDisconnection"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/listener/PacketListener;onDisconnected(Lnet/minecraft/text/Text;)V")})
    private void disconnectAddon(CallbackInfo ci) {
        class_2547 class_25472 = this.field_11652;
        if (class_25472 instanceof NetworkHandlerExtensions) {
            NetworkHandlerExtensions extension = (NetworkHandlerExtensions)class_25472;
            extension.getAddon().handleDisconnect();
        }
    }

    @Inject(method={"sendInternal"}, at={@At(value="INVOKE", target="Lio/netty/channel/ChannelFuture;addListener(Lio/netty/util/concurrent/GenericFutureListener;)Lio/netty/channel/ChannelFuture;", remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void sendInternal(class_2596<?> packet, @Nullable class_7648 callbacks, boolean flush, CallbackInfo ci, ChannelFuture channelFuture) {
        if (callbacks instanceof GenericFutureListenerHolder) {
            GenericFutureListenerHolder holder = (GenericFutureListenerHolder)callbacks;
            channelFuture.addListener(holder.getDelegate());
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            ci.cancel();
        }
    }

    @Override
    public Collection<class_2960> getPendingChannelsNames(class_2539 state) {
        return this.playChannels.computeIfAbsent(state, key -> Collections.newSetFromMap(new ConcurrentHashMap()));
    }
}

