/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.client;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.impl.networking.AbstractNetworkAddon;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.impl.networking.payload.PacketByteBufLoginQueryRequestPayload;
import net.fabricmc.fabric.impl.networking.payload.PacketByteBufLoginQueryResponse;
import net.fabricmc.fabric.mixin.networking.client.accessor.ClientLoginNetworkHandlerAccessor;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2899;
import net.minecraft.class_2913;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_635;
import net.minecraft.class_7648;
import net.minecraft.class_8594;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientLoginNetworkAddon
extends AbstractNetworkAddon<ClientLoginNetworking.LoginQueryRequestHandler> {
    private final class_635 handler;
    private final class_310 client;
    private boolean firstResponse = true;

    public ClientLoginNetworkAddon(class_635 handler, class_310 client) {
        super(ClientNetworkingImpl.LOGIN, "ClientLoginNetworkAddon for Client");
        this.handler = handler;
        this.client = client;
    }

    @Override
    protected void invokeInitEvent() {
        ((ClientLoginConnectionEvents.Init)ClientLoginConnectionEvents.INIT.invoker()).onLoginStart(this.handler, this.client);
    }

    public boolean handlePacket(class_2899 packet) {
        PacketByteBufLoginQueryRequestPayload payload = (PacketByteBufLoginQueryRequestPayload)packet.comp_1568();
        return this.handlePacket(packet.comp_1567(), packet.comp_1568().comp_1571(), payload.data());
    }

    private boolean handlePacket(int queryId, class_2960 channelName, class_2540 originalBuf) {
        ClientLoginNetworking.LoginQueryRequestHandler handler;
        this.logger.debug("Handling inbound login response with id {} and channel with name {}", (Object)queryId, (Object)channelName);
        if (this.firstResponse) {
            ((ClientLoginConnectionEvents.QueryStart)ClientLoginConnectionEvents.QUERY_START.invoker()).onLoginQueryStart(this.handler, this.client);
            this.firstResponse = false;
        }
        if ((handler = (ClientLoginNetworking.LoginQueryRequestHandler)this.getHandler(channelName)) == null) {
            return false;
        }
        class_2540 buf = PacketByteBufs.slice((ByteBuf)originalBuf);
        final ArrayList callbacks = new ArrayList();
        try {
            CompletableFuture<@Nullable class_2540> future = handler.receive(this.client, this.handler, buf, callbacks::add);
            future.thenAccept(result -> {
                class_2913 packet = new class_2913(queryId, (class_8594)(result == null ? null : new PacketByteBufLoginQueryResponse((class_2540)result)));
                ((ClientLoginNetworkHandlerAccessor)this.handler).getConnection().method_10752((class_2596)packet, new class_7648(){

                    public void method_45083() {
                        callbacks.forEach(class_7648::method_45083);
                    }
                });
            });
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel with name \"{}\"", (Object)channelName, (Object)ex);
            throw ex;
        }
        return true;
    }

    @Override
    protected void handleRegistration(class_2960 channelName) {
    }

    @Override
    protected void handleUnregistration(class_2960 channelName) {
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ClientLoginConnectionEvents.Disconnect)ClientLoginConnectionEvents.DISCONNECT.invoker()).onLoginDisconnect(this.handler, this.client);
    }

    @Override
    protected boolean isReservedChannel(class_2960 channelName) {
        return false;
    }
}

