/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.rendering.data.attachment.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_853;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_853.class})
public abstract class MixinChunkRendererRegion
implements RenderAttachedBlockView {
    private Int2ObjectOpenHashMap<Object> fabric_renderDataObjects;
    private static final AtomicInteger ERROR_COUNTER = new AtomicInteger();
    private static final Logger LOGGER = LogManager.getLogger();

    @Shadow
    protected abstract int method_3691(class_2338 var1);

    @Shadow
    protected abstract int method_3690(int var1, int var2, int var3);

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    public void init(class_1937 world, int cxOff, int czOff, class_2818[][] chunks, class_2338 posFrom, class_2338 posTo, CallbackInfo info) {
        Int2ObjectOpenHashMap<Object> map = null;
        class_2818[][] class_2818Array = chunks;
        int n = class_2818Array.length;
        for (int i = 0; i < n; ++i) {
            class_2818[] chunkOuter;
            block3: for (class_2818 chunk : chunkOuter = class_2818Array[i]) {
                while (true) {
                    try {
                        map = this.mapChunk(chunk, posFrom, posTo, map);
                        continue block3;
                    }
                    catch (ConcurrentModificationException e) {
                        int count = ERROR_COUNTER.incrementAndGet();
                        if (count > 5) continue;
                        LOGGER.warn("[Render Data Attachment] Encountered CME during render region build. A mod is accessing or changing chunk data outside the main thread. Retrying.", (Throwable)e);
                        if (count != 5) continue;
                        LOGGER.info("[Render Data Attachment] Subsequent exceptions will be suppressed.");
                        continue;
                    }
                    break;
                }
            }
        }
        this.fabric_renderDataObjects = map;
    }

    private Int2ObjectOpenHashMap<Object> mapChunk(class_2818 chunk, class_2338 posFrom, class_2338 posTo, Int2ObjectOpenHashMap<Object> map) {
        int xMin = posFrom.method_10263();
        int xMax = posTo.method_10263();
        int zMin = posFrom.method_10260();
        int zMax = posTo.method_10260();
        int yMin = posFrom.method_10264();
        int yMax = posTo.method_10264();
        for (Map.Entry entry : chunk.method_12214().entrySet()) {
            Object o;
            class_2338 entPos = (class_2338)entry.getKey();
            if (entPos.method_10263() < xMin || entPos.method_10263() > xMax || entPos.method_10264() < yMin || entPos.method_10264() > yMax || entPos.method_10260() < zMin || entPos.method_10260() > zMax || (o = ((RenderAttachmentBlockEntity)entry.getValue()).getRenderAttachmentData()) == null) continue;
            if (map == null) {
                map = new Int2ObjectOpenHashMap();
            }
            map.put(this.method_3691(entPos), o);
        }
        return map;
    }

    @Override
    public Object getBlockEntityRenderAttachment(class_2338 pos) {
        return this.fabric_renderDataObjects == null ? null : this.fabric_renderDataObjects.get(this.method_3691(pos));
    }
}

