/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.rendering.data.attachment.client;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_853;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_853.class})
public abstract class MixinChunkRendererRegion
implements RenderAttachedBlockView {
    private Long2ObjectOpenHashMap<Object> fabric_renderDataObjects;
    private static final AtomicInteger ERROR_COUNTER = new AtomicInteger();
    private static final Logger LOGGER = LogManager.getLogger();

    @Inject(at={@At(value="RETURN")}, method={"create"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void init(class_1937 world, class_2338 startPos, class_2338 endPos, int chunkRadius, CallbackInfoReturnable<class_853> info, int i, int j, int k, int l, class_2818[][] chunks) {
        Long2ObjectOpenHashMap<Object> map = null;
        class_2818[][] class_2818Array = chunks;
        int n = class_2818Array.length;
        for (int i2 = 0; i2 < n; ++i2) {
            class_2818[] chunkOuter;
            block3: for (class_2818 chunk : chunkOuter = class_2818Array[i2]) {
                while (true) {
                    try {
                        map = MixinChunkRendererRegion.mapChunk(chunk, startPos, endPos, map);
                        continue block3;
                    }
                    catch (ConcurrentModificationException e) {
                        int count = ERROR_COUNTER.incrementAndGet();
                        if (count > 5) continue;
                        LOGGER.warn("[Render Data Attachment] Encountered CME during render region build. A mod is accessing or changing chunk data outside the main thread. Retrying.", (Throwable)e);
                        if (count != 5) continue;
                        LOGGER.info("[Render Data Attachment] Subsequent exceptions will be suppressed.");
                        continue;
                    }
                    break;
                }
            }
        }
        class_853 rendererRegion = (class_853)info.getReturnValue();
        if (map != null && rendererRegion != null) {
            ((MixinChunkRendererRegion)rendererRegion).fabric_renderDataObjects = map;
        }
    }

    private static Long2ObjectOpenHashMap<Object> mapChunk(class_2818 chunk, class_2338 posFrom, class_2338 posTo, Long2ObjectOpenHashMap<Object> map) {
        int xMin = posFrom.method_10263();
        int xMax = posTo.method_10263();
        int zMin = posFrom.method_10260();
        int zMax = posTo.method_10260();
        int yMin = posFrom.method_10264();
        int yMax = posTo.method_10264();
        for (Map.Entry entry : chunk.method_12214().entrySet()) {
            Object o;
            class_2338 entPos = (class_2338)entry.getKey();
            if (entPos.method_10263() < xMin || entPos.method_10263() > xMax || entPos.method_10264() < yMin || entPos.method_10264() > yMax || entPos.method_10260() < zMin || entPos.method_10260() > zMax || (o = ((RenderAttachmentBlockEntity)entry.getValue()).getRenderAttachmentData()) == null) continue;
            if (map == null) {
                map = new Long2ObjectOpenHashMap();
            }
            map.put(entPos.method_10063(), o);
        }
        return map;
    }

    @Override
    public Object getBlockEntityRenderAttachment(class_2338 pos) {
        return this.fabric_renderDataObjects == null ? null : this.fabric_renderDataObjects.get(pos.method_10063());
    }
}

