package p455w0rdslib.client.gui.element;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import p455w0rdslib.api.gui.IModularGui;
import p455w0rdslib.util.RenderUtils;

/**
 * @author p455w0rd
 *
 */
public class GuiButton extends GuiElement {

	int borderColor = 0xFF000000, backgroundColor = 0xFFCCCCCC, textColor = 0xFFFFFFFF;
	String text = "";

	public GuiButton(final IModularGui gui, final GuiPos posIn, final int height, final String label) {
		this(gui, posIn, ((GuiContainer) gui).getXSize() - posIn.getX() * 2, height, label);
	}

	public GuiButton(final IModularGui gui, final GuiPos posIn, final int width, final int height, final String label) {
		super(gui, posIn, width, height);
		text = label;
	}

	@Override
	public void drawBackground(final int mouseX, final int mouseY, final float gameTicks) {
		Gui.drawRect(getX(), getY(), getX() + getWidth() + 1, getY() + getHeight() + 1, borderColor);
		Gui.drawRect(getX() + 1, getY() + 1, getX() + getWidth(), getY() + getHeight(), backgroundColor);
	}

	@Override
	public void drawForeground(final int mouseX, final int mouseY) {
		drawCenteredString(text);
	}

	public int getBGColor() {
		return backgroundColor;
	}

	public GuiButton setBGColor(final int color) {
		backgroundColor = color;
		return this;
	}

	public int getBorderColor() {
		return borderColor;
	}

	public GuiButton setBorderColor(final int color) {
		borderColor = color;
		return this;
	}

	public int getTextColor() {
		return textColor;
	}

	public GuiButton setTextColor(final int color) {
		textColor = color;
		return this;
	}

	public void drawCenteredString(final String text) {
		final int x1 = getWidth() / 2 - RenderUtils.getFontRenderer().getStringWidth(text) / 2;
		RenderUtils.getFontRenderer().drawStringWithShadow(text, getX() + x1, getY() + 3, textColor);
	}

	public String getLabel() {
		return text;
	}

	public GuiButton setLabel(final String label) {
		text = label;
		return this;
	}

}
