package p455w0rdslib.util;

import java.math.*;

import p455w0rdslib.api.ICopyable;

/**
 * @author p455w0rd
 *
 */
public class Quat implements ICopyable<Quat> {

	public double x;
	public double y;
	public double z;
	public double s;

	public Quat() {
		s = 1;
		x = 0;
		y = 0;
		z = 0;
	}

	public Quat(final Quat quat) {
		x = quat.x;
		y = quat.y;
		z = quat.z;
		s = quat.s;
	}

	public Quat(final double d, final double d1, final double d2, final double d3) {
		x = d1;
		y = d2;
		z = d3;
		s = d;
	}

	public Quat set(final Quat quat) {
		x = quat.x;
		y = quat.y;
		z = quat.z;
		s = quat.s;

		return this;
	}

	public Quat set(final double d, final double d1, final double d2, final double d3) {
		x = d1;
		y = d2;
		z = d3;
		s = d;

		return this;
	}

	public double getRed() {
		return x;
	}

	public double getGreen() {
		return y;
	}

	public double getBlue() {
		return z;
	}

	public double getAlpha() {
		return s;
	}

	public static Quat aroundAxis(final double ax, final double ay, final double az, final double angle) {
		return new Quat().setAroundAxis(ax, ay, az, angle);
	}

	public static Quat aroundAxis(final Vector3 axis, final double angle) {
		return aroundAxis(axis.x, axis.y, axis.z, angle);
	}

	public Quat setAroundAxis(final double ax, final double ay, final double az, double angle) {
		angle *= 0.5;
		final double d4 = MathUtils.sin((float) angle);
		return set(MathUtils.cos((float) angle), ax * d4, ay * d4, az * d4);
	}

	public Quat setAroundAxis(final Vector3 axis, final double angle) {
		return setAroundAxis(axis.x, axis.y, axis.z, angle);
	}

	public Quat multiply(final Quat quat) {
		final double d = s * quat.s - x * quat.x - y * quat.y - z * quat.z;
		final double d1 = s * quat.x + x * quat.s - y * quat.z + z * quat.y;
		final double d2 = s * quat.y + x * quat.z + y * quat.s - z * quat.x;
		final double d3 = s * quat.z - x * quat.y + y * quat.x + z * quat.s;
		s = d;
		x = d1;
		y = d2;
		z = d3;

		return this;
	}

	public Quat rightMultiply(final Quat quat) {
		final double d = s * quat.s - x * quat.x - y * quat.y - z * quat.z;
		final double d1 = s * quat.x + x * quat.s + y * quat.z - z * quat.y;
		final double d2 = s * quat.y - x * quat.z + y * quat.s + z * quat.x;
		final double d3 = s * quat.z + x * quat.y - y * quat.x + z * quat.s;
		s = d;
		x = d1;
		y = d2;
		z = d3;

		return this;
	}

	public double mag() {
		return Math.sqrt(x * x + y * y + z * z + s * s);
	}

	public Quat normalize() {
		double d = mag();
		if (d != 0) {
			d = 1 / d;
			x *= d;
			y *= d;
			z *= d;
			s *= d;
		}

		return this;
	}

	@Override
	public Quat copy() {
		return new Quat(this);
	}

	public void rotate(final Vector3 vec) {
		final double d = -x * vec.x - y * vec.y - z * vec.z;
		final double d1 = s * vec.x + y * vec.z - z * vec.y;
		final double d2 = s * vec.y - x * vec.z + z * vec.x;
		final double d3 = s * vec.z + x * vec.y - y * vec.x;
		vec.x = d1 * s - d * x - d2 * z + d3 * y;
		vec.y = d2 * s - d * y + d1 * z - d3 * x;
		vec.z = d3 * s - d * z - d1 * y + d2 * x;
	}

	@Override
	public String toString() {
		final MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
		return "Quat(" + new BigDecimal(s, cont) + ", " + new BigDecimal(x, cont) + ", " + new BigDecimal(y, cont) + ", " + new BigDecimal(z, cont) + ")";
	}
	/*
	public Rotation rotation() {
	    return new Rotation(this);
	}
	*/
}