/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib;

import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import p455w0rdslib.LibConfig;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.LibKeyBindings;
import p455w0rdslib.LibShaders;
import p455w0rdslib.P455w0rdsLib;
import p455w0rdslib.api.IChunkLoadable;
import p455w0rdslib.api.client.ItemRenderingRegistry;
import p455w0rdslib.api.client.shader.IBlockLightEmitter;
import p455w0rdslib.api.client.shader.LightHandler;
import p455w0rdslib.api.event.BlockGenEvent;
import p455w0rdslib.capabilities.CapabilityChunkLoader;
import p455w0rdslib.capabilities.CapabilityLightEmitter;
import p455w0rdslib.handlers.BrightnessHandler;
import p455w0rdslib.integration.Albedo;
import p455w0rdslib.util.ContributorUtils;

@Mod.EventBusSubscriber(modid="p455w0rdslib")
public class LibEvents {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void tickStart(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.type != TickEvent.Type.CLIENT || event.side != Side.CLIENT) {
            return;
        }
        if (LibGlobals.areShadersEnabled() && LibGlobals.ConfigOptions.ENABLE_SHADERS) {
            BrightnessHandler.tickAllHandlers();
        }
        if (FMLClientHandler.instance().getWorldClient() != null) {
            if (Keyboard.isKeyDown((int)72)) {
                LibShaders.reload();
            }
            ++LibGlobals.ELAPSED_TICKS;
            if ((LibGlobals.TIME2 += 1.0f) > 360.0f) {
                LibGlobals.TIME2 = 0.0f;
            }
            if (LibGlobals.TURN == 0 && (LibGlobals.GREEN += 15) == 255) {
                LibGlobals.TURN = 1;
            }
            if (LibGlobals.TURN == 1 && (LibGlobals.RED -= 15) == 0) {
                LibGlobals.TURN = 2;
            }
            if (LibGlobals.TURN == 2 && (LibGlobals.BLUE += 15) == 255) {
                LibGlobals.TURN = 3;
            }
            if (LibGlobals.TURN == 3 && (LibGlobals.GREEN -= 15) == 0) {
                LibGlobals.TURN = 4;
            }
            if (LibGlobals.TURN == 4 && (LibGlobals.RED += 15) == 255) {
                LibGlobals.TURN = 5;
            }
            if (LibGlobals.TURN == 5 && (LibGlobals.BLUE -= 15) == 0) {
                LibGlobals.TURN = 0;
            }
        } else if (LibGlobals.ELAPSED_TICKS != 0) {
            LibGlobals.ELAPSED_TICKS = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onKeyBind(InputEvent.KeyInputEvent event) {
        if (LibKeyBindings.TOGGLE_SHADERS.func_151468_f() && LibGlobals.areShadersEnabled()) {
            LibGlobals.ConfigOptions.ENABLE_SHADERS = !LibGlobals.ConfigOptions.ENABLE_SHADERS;
            LibConfig.CONFIG.save();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void entityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
            if (player.func_110124_au().equals(P455w0rdsLib.PROXY.getPlayer().func_110124_au()) && !LibGlobals.ConfigOptions.ENABLE_CONTRIB_CAPE) {
                return;
            }
            try {
                ContributorUtils.queuePlayerCosmetics(player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onPlace(BlockEvent.PlaceEvent e) {
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        if (world != null && pos != null) {
            TileEntity tile;
            if (world.func_175625_s(pos) != null && (tile = world.func_175625_s(pos)) instanceof IChunkLoadable && tile.hasCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)) {
                IChunkLoadable chunkLoader = (IChunkLoadable)tile;
                ((CapabilityChunkLoader.ICLTEHandler)tile.getCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)).attachChunkLoader(chunkLoader.getModInstance());
            }
            if (e.getPlacedBlock().func_177230_c() instanceof IBlockLightEmitter) {
                LightHandler.addCachedPos(world, pos);
            } else if ((Integer)CapabilityLightEmitter.getColorForBlock(e.getState().func_177230_c()).getLeft() != 0) {
                LightHandler.addCachedPos(world, pos);
            }
        }
    }

    @SubscribeEvent
    public static void blockBreak(BlockEvent.BreakEvent e) {
        TileEntity tile;
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        if (world != null && pos != null && world.func_175625_s(pos) != null && (tile = world.func_175625_s(pos)) instanceof IChunkLoadable && tile.hasCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)) {
            IChunkLoadable chunkLoader = (IChunkLoadable)tile;
            ((CapabilityChunkLoader.ICLTEHandler)tile.getCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)).detachChunkLoader(chunkLoader.getModInstance());
        }
        if (e.getState().func_177230_c() instanceof IBlockLightEmitter) {
            LightHandler.removeCachedPositions(e.getWorld(), Lists.newArrayList((Object[])new BlockPos[]{e.getPos()}));
        } else if ((Integer)CapabilityLightEmitter.getColorForBlock(e.getState().func_177230_c()).getLeft() != 0) {
            LightHandler.removeCachedPositions(e.getWorld(), Lists.newArrayList((Object[])new BlockPos[]{e.getPos()}));
        }
    }

    @SubscribeEvent
    public static void attachTileCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        IChunkLoadable chunkLoader;
        TileEntity tile = (TileEntity)event.getObject();
        if (event.getObject() instanceof IChunkLoadable && (chunkLoader = (IChunkLoadable)tile).shouldChunkLoad()) {
            event.addCapability(new ResourceLocation(chunkLoader.getModID(), "chunkloader"), (ICapabilityProvider)new CapabilityChunkLoader.ProviderTE(tile));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> e) {
        if (LibGlobals.Mods.ALBEDO.isLoaded()) {
            if (e.getObject() instanceof EntityPlayer) {
                e.addCapability(new ResourceLocation("pwlib:albedo_entity_cap"), Albedo.getEmptyProvider());
            }
        } else if (LibGlobals.areShadersEnabled() && LibGlobals.ConfigOptions.ENABLE_SHADERS && e.getObject() instanceof EntityPlayer) {
            e.addCapability(new ResourceLocation("pwlib:light_emitter_cap"), CapabilityLightEmitter.getDummyProvider());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void attachStackCapabilities(AttachCapabilitiesEvent<ItemStack> e) {
        ItemStack stack = (ItemStack)e.getObject();
        if (LibGlobals.Mods.ALBEDO.isLoaded()) {
            if ((Integer)CapabilityLightEmitter.getColorForStack(stack).getLeft() != 0) {
                e.addCapability(new ResourceLocation("pwlib:albedo_stack_cap"), Albedo.getVanillaStackProvider(stack));
            }
        } else if (LibGlobals.areShadersEnabled() && LibGlobals.ConfigOptions.ENABLE_SHADERS && (Integer)CapabilityLightEmitter.getColorForStack(stack).getLeft() != 0 && !((ItemStack)e.getObject()).hasCapability(CapabilityLightEmitter.LIGHT_EMITTER_CAPABILITY, null)) {
            e.addCapability(new ResourceLocation("pwlib:light_emitter_cap"), CapabilityLightEmitter.getVanillaStackProvider(stack));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onMapGen(InitMapGenEvent event) {
        switch (event.getType()) {
            case NETHER_BRIDGE: 
            case END_CITY: {
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        Chunk c = event.getChunk();
        ChunkPos cPos = c.func_76632_l();
        for (int x = cPos.func_180334_c(); x < cPos.func_180332_e(); ++x) {
            for (int z = cPos.func_180333_d(); z < cPos.func_180330_f(); ++z) {
                for (int y = 0; y <= 255; ++y) {
                    IBlockState state = c.func_177435_g(new BlockPos(x, y, z));
                    if (state == null) continue;
                    MinecraftForge.TERRAIN_GEN_BUS.post((Event)new BlockGenEvent(event.getWorld(), new BlockPos(x, y, z), state));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockGen(BlockGenEvent event) {
        IBlockState state = event.getState();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (state != null) {
            Block b = event.getState().func_177230_c();
            if (event.getPos() != null) {
                if (b instanceof IBlockLightEmitter) {
                    LightHandler.addCachedPos(event.getWorld(), event.getPos());
                } else if (b != null) {
                    if (b instanceof IBlockLightEmitter) {
                        LightHandler.addCachedPos(world, pos);
                    } else if ((Integer)CapabilityLightEmitter.getColorForBlock(b).getLeft() != 0) {
                        LightHandler.addCachedPos(world, pos);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelBake(ModelBakeEvent event) {
        ItemRenderingRegistry.initModels(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegister(ModelRegistryEvent event) {
        ItemRenderingRegistry.registerTEISRs(event);
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
    }
}

