/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.asm;

import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.CoreModManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import p455w0rdslib.asm.CustomClassWriter;
import p455w0rdslib.asm.FMLPlugin;
import p455w0rdslib.asm.Hooks;

public class ClassTransformer
implements IClassTransformer {
    private static final String RENDERGLOBAL_CLASS = "net.minecraft.client.renderer.RenderGlobal";
    private static final String CHUNKRENDERCONTAINER_CLASS = "net.minecraft.client.renderer.ChunkRenderContainer";
    private static final String HOOKS_PATH = "p455w0rdslib/asm/Hooks";
    private static boolean init = false;
    private static boolean enabled = true;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!init) {
            init = true;
            for (Map.Entry e : CoreModManager.getTransformers().entrySet()) {
                if (((String)((List)e.getValue()).get(0)).equals("elucent.albedo.asm.ASMTransformer")) {
                    enabled = false;
                    Hooks.conflictDetected = true;
                    FMLPlugin.log("Albedo detected; Patching aborted :D");
                    continue;
                }
                if (!this.detectOptifine()) continue;
                enabled = false;
                Hooks.conflictDetected = true;
                FMLPlugin.log("Optifine detected; Patching aborted :D");
            }
        }
        if (enabled) {
            if (transformedName.equals(RENDERGLOBAL_CLASS)) {
                return ClassTransformer.patchRenderGlobal(basicClass);
            }
            if (transformedName.equals(CHUNKRENDERCONTAINER_CLASS)) {
                return ClassTransformer.patchChunkRenderContainer(basicClass);
            }
        }
        return basicClass;
    }

    private boolean detectOptifine() {
        try {
            if (Class.forName("optifine.OptiFineClassTransformer") != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static byte[] patchRenderGlobal(byte[] c) {
        ClassReader reader = new ClassReader(c);
        ClassNode node = new ClassNode();
        boolean found = false;
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (found) break;
            if (!method.name.equals("func_174982_a") && !method.name.equals("renderBlockLayer") || !method.desc.equals("(Lnet/minecraft/util/BlockRenderLayer;)V")) continue;
            InsnList instr = method.instructions;
            instr.insert(instr.getFirst(), (AbstractInsnNode)new MethodInsnNode(184, HOOKS_PATH, "enableColoredLighting", "()V", false));
            AbstractInsnNode[] nodeList = instr.toArray();
            for (int i = nodeList.length - 1; i >= 0; --i) {
                AbstractInsnNode currentNode = nodeList[i];
                if (currentNode.getOpcode() != 177) continue;
                instr.insertBefore(currentNode, (AbstractInsnNode)new MethodInsnNode(184, HOOKS_PATH, "disableColoredLighting", "()V", false));
                FMLPlugin.log("Successfully patched net.minecraft.client.renderer.RenderGlobal#renderBlockLayer(Lnet/minecraft/util/BlockRenderLayer;)V");
                found = true;
                continue block0;
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private static byte[] patchChunkRenderContainer(byte[] c) {
        ClassReader reader = new ClassReader(c);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("func_178003_a") && !method.name.equals("preRenderChunk") || !method.desc.equals("(Lnet/minecraft/client/renderer/chunk/RenderChunk;)V")) continue;
            InsnList instr = method.instructions;
            AbstractInsnNode[] nodeList = instr.toArray();
            for (int i = nodeList.length - 1; i >= 0; --i) {
                AbstractInsnNode currentNode = nodeList[i];
                if (currentNode.getOpcode() != 177) continue;
                instr.insertBefore(currentNode, (AbstractInsnNode)new VarInsnNode(25, 1));
                instr.insertBefore(currentNode, (AbstractInsnNode)new MethodInsnNode(184, HOOKS_PATH, "preRenderChunk", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;)V", false));
                FMLPlugin.log("Successfully patched net.minecraft.client.renderer.ChunkRenderContainer#preRenderChunk(Lnet/minecraft/client/renderer/chunk/RenderChunk;)V");
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

