/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.api.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rdslib.api.client.IModelHolder;
import p455w0rdslib.api.client.ItemLayerWrapper;

@SideOnly(value=Side.CLIENT)
public class ItemRenderingRegistry {
    private static List<IModelHolder> ITEM_RENDERING_REGISTRY = new ArrayList<IModelHolder>();

    public static List<IModelHolder> getRegisteredItems() {
        return ITEM_RENDERING_REGISTRY;
    }

    public static void registerCustomRenderingItem(IModelHolder holder) {
        if (!ITEM_RENDERING_REGISTRY.contains(holder)) {
            ITEM_RENDERING_REGISTRY.add(holder);
        }
    }

    public static final void initModels(ModelBakeEvent event) {
        for (IModelHolder holder : ITEM_RENDERING_REGISTRY) {
            if (!(holder instanceof Item)) continue;
            ItemRenderingRegistry.initModel(event, (Item)holder);
        }
    }

    private static final void initModel(ModelBakeEvent event, Item item) {
        IModelHolder holder = (IModelHolder)item;
        holder.initModel();
        if (holder.shouldUseInternalTEISR() && holder.getRenderer() != null) {
            IBakedModel currentModel = (IBakedModel)event.getModelRegistry().getObject((Object)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            holder.setWrappedModel(new ItemLayerWrapper(currentModel).setRenderer(holder.getRenderer()));
            event.getModelRegistry().putObject((Object)new ModelResourceLocation(item.getRegistryName(), "inventory"), (Object)holder.getWrappedModel());
        }
    }

    public static final void registerTEISRs(ModelRegistryEvent event) {
        for (IModelHolder holder : ITEM_RENDERING_REGISTRY) {
            if (!holder.shouldUseInternalTEISR() || holder.getRenderer() == null) continue;
            ((Item)holder).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)holder.getRenderer());
        }
    }
}

