/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.api.typeadapters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.LogManager;

public class WrappedBlockState {
    public static final List<WrappedBlockState> ERRORED = new ArrayList<WrappedBlockState>();
    @Nullable
    private final ResourceLocation name;
    @Nullable
    private final Map<String, String> properties;
    @Nullable
    private IBlockState resolved;

    public WrappedBlockState(@Nullable ResourceLocation name, @Nullable Map<String, String> properties) {
        this.name = name;
        this.properties = properties;
    }

    @Nullable
    public ResourceLocation getName() {
        return this.name;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public IBlockState getBlockState() {
        if (this.resolved == null) {
            this.resolved = this.resolveBlockState();
        }
        return this.resolved;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrappedBlockState that = (WrappedBlockState)o;
        if (this.name != null ? !this.name.equals((Object)that.name) : that.name != null) {
            return false;
        }
        return !(this.properties != null ? !this.properties.equals(that.properties) : that.properties != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(32);
        s.append(this.name);
        if (this.properties != null && !this.properties.isEmpty()) {
            s.append('[');
            boolean isFirst = true;
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    s.append(',');
                }
                s.append(entry.getKey());
                s.append('=');
                s.append(entry.getValue());
            }
            s.append(']');
        }
        return s.toString();
    }

    private IBlockState resolveBlockState() {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(this.name);
        if (block == null || block == Blocks.AIR) {
            return Blocks.AIR.getDefaultState();
        }
        IBlockState state = block.getDefaultState();
        if (this.properties != null) {
            block0: for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String serializedKey = entry.getKey();
                String serializedValue = entry.getValue();
                for (IProperty property : state.getPropertyKeys()) {
                    if (!Objects.equals(property.getName(), serializedKey)) continue;
                    Comparable originalValue = state.getValue(property);
                    while (!Objects.equals(property.getName(state.getValue(property)), serializedValue)) {
                        if (!Objects.equals((state = state.cycleProperty(property)).getValue(property), originalValue)) continue;
                        LogManager.getLogger((String)"p455w0rdslib").warn("Cannot parse property value '{}' for property '{}' of block {}.", (Object)serializedValue, (Object)serializedKey, (Object)this.name);
                        ERRORED.add(this);
                        return Blocks.AIR.getDefaultState();
                    }
                    continue block0;
                }
                LogManager.getLogger((String)"p455w0rdslib").warn("Block {} has no property '{}'.", (Object)this.name, (Object)serializedKey);
                ERRORED.add(this);
                return Blocks.AIR.getDefaultState();
            }
        }
        return state;
    }
}

