/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.capabilities;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import p455w0rdslib.util.CapabilityUtils;
import p455w0rdslib.util.ChunkUtils;

public class CapabilityChunkLoader {
    @CapabilityInject(value=ICLTEHandler.class)
    public static Capability<ICLTEHandler> CAPABILITY_CHUNKLOADER_TE = null;
    @CapabilityInject(value=ICLEntityHandler.class)
    public static Capability<ICLEntityHandler> CAPABILITY_CHUNKLOADER_ENTITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(ICLTEHandler.class, new CapabilityUtils.EmptyStorage(), DefaultCLTEHandler::new);
        CapabilityManager.INSTANCE.register(ICLEntityHandler.class, (Capability.IStorage)new StorageEntity(), DefaultCLEntityHandler::new);
    }

    public static ICLTEHandler get(TileEntity tile) {
        if (tile.hasCapability(CAPABILITY_CHUNKLOADER_TE, null)) {
            return (ICLTEHandler)tile.getCapability(CAPABILITY_CHUNKLOADER_TE, null);
        }
        return null;
    }

    public static ICLEntityHandler get(Entity entity) {
        if (entity.hasCapability(CAPABILITY_CHUNKLOADER_ENTITY, null)) {
            return (ICLEntityHandler)entity.getCapability(CAPABILITY_CHUNKLOADER_ENTITY, null);
        }
        return null;
    }

    public static class ProviderEntity
    implements ICapabilitySerializable<NBTTagCompound> {
        ICLEntityHandler instance = (ICLEntityHandler)CAPABILITY_CHUNKLOADER_ENTITY.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CAPABILITY_CHUNKLOADER_ENTITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CAPABILITY_CHUNKLOADER_ENTITY.cast((Object)this.instance) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)CAPABILITY_CHUNKLOADER_ENTITY.getStorage().writeNBT(CAPABILITY_CHUNKLOADER_ENTITY, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            CAPABILITY_CHUNKLOADER_ENTITY.getStorage().readNBT(CAPABILITY_CHUNKLOADER_ENTITY, (Object)this.instance, null, (NBTBase)nbt);
        }
    }

    public static class ProviderTE
    implements ICapabilityProvider {
        ICLTEHandler instance;
        TileEntity tile;

        public ProviderTE(TileEntity te) {
            this.tile = te;
            this.instance = new DefaultCLTEHandler();
            this.instance.setTileEntity(te);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CAPABILITY_CHUNKLOADER_TE;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CAPABILITY_CHUNKLOADER_TE.cast((Object)this.instance) : null);
        }
    }

    public static class StorageEntity
    implements Capability.IStorage<ICLEntityHandler> {
        public NBTBase writeNBT(Capability<ICLEntityHandler> capability, ICLEntityHandler instance, EnumFacing side) {
            NBTTagCompound properties = new NBTTagCompound();
            NBTTagList ownedchunkloaders = new NBTTagList();
            properties.setTag("ownedchunkloaders", (NBTBase)ownedchunkloaders);
            for (int i = 0; i < instance.getList().size(); ++i) {
                NBTTagCompound entry = new NBTTagCompound();
                entry.setLong("pos" + i, instance.getList().get(i).toLong());
                ownedchunkloaders.appendTag((NBTBase)entry);
            }
            return properties;
        }

        public void readNBT(Capability<ICLEntityHandler> capability, ICLEntityHandler instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound properties = (NBTTagCompound)nbt;
            if (properties.hasKey("ownedchunkloaders", 9)) {
                NBTTagList ownedchunkloaders = properties.getTagList("ownedchunkloaders", 10);
                int count = ownedchunkloaders.tagCount();
                for (int i = 0; i < count; ++i) {
                    instance.add(BlockPos.fromLong((long)ownedchunkloaders.getCompoundTagAt(i).getLong("pos")));
                }
            }
        }
    }

    public static class DefaultCLEntityHandler
    implements ICLEntityHandler {
        private ArrayList<BlockPos> chunkLoaderList = new ArrayList();

        @Override
        public ArrayList<BlockPos> getList() {
            return this.chunkLoaderList;
        }

        @Override
        public void add(BlockPos pos) {
            this.chunkLoaderList.add(pos);
        }

        @Override
        public void remove(BlockPos pos) {
            this.chunkLoaderList.remove(pos);
        }

        @Override
        public void set(ArrayList<BlockPos> list) {
            this.chunkLoaderList = list;
        }

        @Override
        public int total() {
            return this.chunkLoaderList.size();
        }
    }

    public static class DefaultCLTEHandler
    implements ICLTEHandler {
        TileEntity tile;

        @Override
        public void setTileEntity(TileEntity te) {
            this.tile = te;
        }

        @Override
        public void attachChunkLoader(Object modInstance) {
            if (this.tile != null) {
                ChunkUtils.TicketHandler handler = ChunkUtils.TicketHandler.getInstance();
                FMLCommonHandler.instance().getMinecraftServerInstance().addScheduledTask(() -> handler.load(this.tile.getWorld(), this.tile.getPos(), handler.getTicket(modInstance, this.tile.getWorld())));
            }
        }

        @Override
        public void detachChunkLoader(Object modInstance) {
            if (this.tile != null) {
                ChunkUtils.TicketHandler handler = ChunkUtils.TicketHandler.getInstance();
                FMLCommonHandler.instance().getMinecraftServerInstance().addScheduledTask(() -> handler.unload(this.tile.getWorld(), this.tile.getPos(), handler.getTicket(modInstance, this.tile.getWorld())));
            }
        }
    }

    public static interface ICLEntityHandler {
        public ArrayList<BlockPos> getList();

        public void add(BlockPos var1);

        public void remove(BlockPos var1);

        public void set(ArrayList<BlockPos> var1);

        public int total();
    }

    public static interface ICLTEHandler {
        public void setTileEntity(TileEntity var1);

        public void attachChunkLoader(Object var1);

        public void detachChunkLoader(Object var1);
    }
}

