/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import p455w0rdslib.api.gui.IGuiElement;
import p455w0rdslib.api.gui.IModularGui;
import p455w0rdslib.util.EasyMappings;

public class GuiModular
extends GuiContainer
implements IModularGui {
    ResourceLocation backgroundTexture = new ResourceLocation("textures/gui/demo_background.png");
    List<IGuiElement> elements = Lists.newArrayList();
    String title = "";
    float titleScale = 1.0f;
    int titleColor = 0xFFFFFF;
    int tooltipColor1 = -15204499;
    int tooltipColor2 = -1726480531;
    int titleOffsetX = 5;
    int titleOffsetY = 6;

    public GuiModular(Container inventorySlotsIn) {
        super(inventorySlotsIn);
    }

    public void initGui() {
        super.initGui();
    }

    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        super.drawScreen(mouseX, mouseY, partialTick);
        this.updateElements(mouseX, mouseY);
        for (IGuiElement element : this.getElements()) {
            if (!element.hasTooltip() || !this.isMouseOverElement(element, mouseX, mouseY)) continue;
            p455w0rdslib.util.GuiUtils.drawToolTipWithBorderColor((GuiScreen)this, element.getTooltip(), mouseX, mouseY, this.tooltipColor1, this.tooltipColor2);
        }
    }

    @Override
    public void updateElements(int mouseX, int mouseY) {
        int i = this.elements.size();
        while (i-- > 0) {
            IGuiElement c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled()) continue;
            c.update(mouseX, mouseY);
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableLighting();
        GlStateManager.disableBlend();
        p455w0rdslib.util.GuiUtils.drawScaledString(this.getTitle(), this.titleOffsetX, this.titleOffsetY, this.titleScale, this.titleColor);
        this.drawElements(0.0f, mouseX, mouseY, true);
        GlStateManager.enableBlend();
        GlStateManager.enableLighting();
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (IGuiElement element : this.getElements()) {
            element.onMousePressed(mouseX - (this.width - this.xSize) / 2, mouseY - (this.height - this.ySize) / 2, mouseButton);
        }
        try {
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void mouseReleased(int mouseX, int mouseY, int button) {
        for (IGuiElement element : this.getElements()) {
            element.onMouseReleased(mouseX - (this.width - this.xSize) / 2, mouseY - (this.height - this.ySize) / 2, button);
        }
        super.mouseReleased(mouseX, mouseY, button);
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        p455w0rdslib.util.GuiUtils.bindTexture(this.backgroundTexture);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)0.0f);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.drawElements(partialTicks, x, y, false);
        GlStateManager.popMatrix();
    }

    @Override
    public int getX() {
        return this.guiLeft;
    }

    @Override
    public int getY() {
        return this.guiTop;
    }

    @Override
    public int getWidth() {
        return this.xSize;
    }

    @Override
    public int getHeight() {
        return this.ySize;
    }

    @Override
    public IModularGui setTitleScale(float scale) {
        this.titleScale = scale;
        return this;
    }

    @Override
    public IModularGui setTitleOffsetX(int offset) {
        this.titleOffsetX = offset;
        return this;
    }

    @Override
    public IModularGui setTitleOffsetY(int offset) {
        this.titleOffsetY = offset;
        return this;
    }

    @Override
    public IModularGui setTitlePos(int x, int y) {
        return this.setTitleOffsetX(x).setTitleOffsetY(y);
    }

    @Override
    public IModularGui setWidth(int w) {
        this.xSize = w;
        return this;
    }

    @Override
    public IModularGui setHeight(int h) {
        this.ySize = h;
        return this;
    }

    @Override
    public IModularGui setSize(int w, int h) {
        return this.setWidth(w).setHeight(h);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IModularGui setTitle(String titleText) {
        this.title = titleText;
        return this;
    }

    @Override
    public int getTitleColor() {
        return this.titleColor;
    }

    @Override
    public IModularGui setTitleColor(int color) {
        this.titleColor = color;
        return this;
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.backgroundTexture;
    }

    @Override
    public IModularGui setBackgroundTexture(ResourceLocation location) {
        this.backgroundTexture = location;
        return this;
    }

    public boolean isMouseOverSlot(Slot slotIn, int mouseX, int mouseY) {
        return this.isMouseOver(EasyMappings.slotPosX(slotIn), EasyMappings.slotPosY(slotIn), 16, 16, mouseX, mouseY);
    }

    @Override
    public boolean isMouseOverElement(IGuiElement element, int mouseX, int mouseY) {
        return this.isMouseOver(element.getX(), element.getY(), element.getWidth(), element.getHeight(), mouseX, mouseY);
    }

    @Override
    public boolean isMouseOver(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return super.isPointInRegion(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    protected void renderToolTip(ItemStack stack, int x, int y) {
        List list = stack.getTooltip(EasyMappings.player(), (ITooltipFlag)(this.mc.gameSettings.advancedItemTooltips ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.getItem().getForgeRarity(stack).getColor() + (String)list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + (String)list.get(i));
        }
        GuiUtils.preItemToolTip((ItemStack)stack);
        p455w0rdslib.util.GuiUtils.drawToolTipWithBorderColor((GuiScreen)this, list, x, y, this.tooltipColor1, this.tooltipColor2);
        GuiUtils.postItemToolTip();
    }

    @Override
    public void drawElements(float partialTick, int mouseX, int mouseY, boolean foreground) {
        if (foreground) {
            for (int i = 0; i < this.elements.size(); ++i) {
                IGuiElement element = this.elements.get(i);
                if (!element.isVisible()) continue;
                element.drawForeground(mouseX, mouseY);
            }
        } else {
            for (int i = 0; i < this.elements.size(); ++i) {
                IGuiElement element = this.elements.get(i);
                if (!element.isVisible()) continue;
                element.drawBackground(mouseX, mouseY, partialTick);
            }
        }
    }

    @Override
    public IModularGui addElement(IGuiElement element) {
        this.elements.add(element);
        return this;
    }

    @Override
    public List<IGuiElement> getElements() {
        return this.elements;
    }

    @Override
    public IModularGui setTooltipColor(int color, boolean top) {
        if (top) {
            this.tooltipColor1 = color;
        } else {
            this.tooltipColor2 = color;
        }
        return this;
    }

    @Override
    public int[] getTooltipColors() {
        return new int[]{this.tooltipColor1, this.tooltipColor2};
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int wheelMovement) {
        return false;
    }

    public void handleMouseInput() throws IOException {
        int x = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int y = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        int mouseX = x - this.guiLeft;
        int mouseY = y - this.guiTop;
        int wheelMovement = Mouse.getEventDWheel();
        if (wheelMovement != 0) {
            int i = this.elements.size();
            while (i-- > 0) {
                IGuiElement c = this.elements.get(i);
                if (!c.isVisible() || !c.isEnabled() || !c.isMouseOver(mouseX, mouseY) || !c.onMouseWheel(mouseX, mouseY, wheelMovement)) continue;
                return;
            }
            if (this.onMouseWheel(mouseX, mouseY, wheelMovement)) {
                return;
            }
        }
        super.handleMouseInput();
    }
}

