/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.client.gui.element;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import p455w0rdslib.api.gui.IModularGui;
import p455w0rdslib.client.gui.element.GuiElement;
import p455w0rdslib.client.gui.element.GuiPos;
import p455w0rdslib.util.RenderUtils;

public class GuiButton
extends GuiElement {
    int borderColor = -16777216;
    int backgroundColor = -3355444;
    int textColor = -1;
    String text = "";

    public GuiButton(IModularGui gui, GuiPos posIn, int height, String label) {
        this(gui, posIn, ((GuiContainer)gui).getXSize() - posIn.getX() * 2, height, label);
    }

    public GuiButton(IModularGui gui, GuiPos posIn, int width, int height, String label) {
        super(gui, posIn, width, height);
        this.text = label;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        Gui.drawRect((int)this.getX(), (int)this.getY(), (int)(this.getX() + this.getWidth() + 1), (int)(this.getY() + this.getHeight() + 1), (int)this.borderColor);
        Gui.drawRect((int)(this.getX() + 1), (int)(this.getY() + 1), (int)(this.getX() + this.getWidth()), (int)(this.getY() + this.getHeight()), (int)this.backgroundColor);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawCenteredString(this.text);
    }

    public int getBGColor() {
        return this.backgroundColor;
    }

    public GuiButton setBGColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public GuiButton setBorderColor(int color) {
        this.borderColor = color;
        return this;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public GuiButton setTextColor(int color) {
        this.textColor = color;
        return this;
    }

    public void drawCenteredString(String text) {
        int x1 = this.getWidth() / 2 - RenderUtils.getFontRenderer().getStringWidth(text) / 2;
        RenderUtils.getFontRenderer().drawStringWithShadow(text, (float)(this.getX() + x1), (float)(this.getY() + 3), this.textColor);
    }

    public String getLabel() {
        return this.text;
    }

    public GuiButton setLabel(String label) {
        this.text = label;
        return this;
    }
}

