/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.client.gui.element;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import p455w0rdslib.api.gui.IGuiElement;
import p455w0rdslib.api.gui.IGuiScrollbar;
import p455w0rdslib.api.gui.IModularGui;
import p455w0rdslib.client.gui.element.GuiElement;
import p455w0rdslib.client.gui.element.GuiPos;

public abstract class GuiScrollbar
extends GuiElement
implements IGuiScrollbar {
    protected int scrollPos;
    protected int minPos;
    protected int maxPos;
    protected int sliderWidth;
    protected int sliderHeight;
    protected int borderColor = -16777216;
    protected int faceColor = -13421773;
    protected boolean dragging;
    IGuiElement parentElement;

    public GuiScrollbar(IModularGui gui, GuiPos posIn, int width, int height, int max) {
        this(gui, posIn, width, height, max, 0);
    }

    public GuiScrollbar(IModularGui gui, GuiPos posIn, int width, int height, int max, int min) {
        super(gui, posIn, width, height);
        this.minPos = min;
        this.maxPos = max;
        this.setSliderWidth(width);
        this.setSliderHeight(15);
    }

    @Override
    public void update(int mouseX, int mouseY) {
        if (this.isDragging()) {
            this.doDrag(mouseX - this.getX(), mouseY - (this.getY() + this.getSliderHeight()));
        }
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.setDragging(mouseButton == 0);
            this.update(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX > this.getX() && mouseY > this.getY() && mouseX <= this.getX() + this.getWidth() && mouseY <= this.getY() + this.getHeight();
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY, int button) {
        if (this.isDragging()) {
            this.onStopDragging();
        }
        this.setDragging(false);
    }

    @Override
    public abstract void doDrag(int var1, int var2);

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        if (this.getParentElement() != null && this.getParentElement().isVisible()) {
            Gui.drawRect((int)(this.getX() - 1), (int)(this.getY() - 1), (int)(this.getX() + this.getWidth() + 1), (int)(this.getY() + this.getHeight() + 1), (int)this.borderColor);
            Gui.drawRect((int)this.getX(), (int)this.getY(), (int)(this.getX() + this.getWidth()), (int)(this.getY() + this.getHeight()), (int)this.faceColor);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (this.getParentElement() != null && this.getParentElement().isVisible()) {
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Gui.drawRect((int)(this.getX() + this.getSliderXPos()), (int)(this.getY() + this.getSliderYPos() - 1), (int)(this.getX() + this.getSliderXPos() + this.getSliderWidth() + 1), (int)(this.getY() + this.getSliderYPos() + this.getSliderHeight() + 1), (int)this.borderColor);
            Gui.drawRect((int)(this.getX() + this.getSliderXPos() + 1), (int)(this.getY() + this.getSliderYPos()), (int)(this.getX() + this.getSliderXPos() + this.getSliderWidth()), (int)(this.getY() + this.getSliderYPos() + this.getSliderHeight()), (int)-3355444);
        }
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int direction) {
        if (this.getParentElement() != null) {
            this.getParentElement().onMouseWheel(mouseX, mouseY, direction);
        } else if (direction > 0) {
            this.setScrollPos(this.getScrollPos() - 1);
        } else if (direction < 0) {
            this.setScrollPos(this.getScrollPos() + 1);
        }
        return true;
    }

    @Override
    public int getSliderXPos() {
        return 0;
    }

    @Override
    public int getSliderYPos() {
        return 0;
    }

    @Override
    public IGuiElement getParentElement() {
        return this.parentElement;
    }

    @Override
    public IGuiScrollbar setParentElement(IGuiElement element) {
        this.parentElement = element;
        return this;
    }

    @Override
    public int getScrollPos() {
        return this.scrollPos;
    }

    @Override
    public IGuiScrollbar setScrollPos(int pos) {
        this.scrollPos = Math.max(this.getMinPos(), Math.min(this.getMaxPos(), pos));
        return this;
    }

    @Override
    public void onStopDragging() {
    }

    @Override
    public int getMinPos() {
        return this.minPos;
    }

    @Override
    public IGuiScrollbar setMinPos(int pos) {
        this.minPos = pos;
        return this;
    }

    @Override
    public int getMaxPos() {
        return this.maxPos;
    }

    @Override
    public IGuiScrollbar setMaxPos(int pos) {
        this.maxPos = pos;
        return this;
    }

    @Override
    public IGuiScrollbar setBounds(int min, int max) {
        this.setMinPos(min);
        this.setMaxPos(max);
        this.setScrollPos(this.getScrollPos());
        return this;
    }

    @Override
    public int getSliderWidth() {
        return this.sliderWidth;
    }

    @Override
    public IGuiScrollbar setSliderWidth(int width) {
        this.sliderWidth = width;
        return this;
    }

    @Override
    public int getSliderHeight() {
        return this.sliderHeight;
    }

    @Override
    public IGuiScrollbar setSliderHeight(int height) {
        this.sliderHeight = height;
        return this;
    }

    @Override
    public int getBorderColor() {
        return this.borderColor;
    }

    @Override
    public IGuiScrollbar setBorderColor(int color) {
        this.borderColor = color;
        return this;
    }

    @Override
    public int getFaceColor() {
        return this.faceColor;
    }

    @Override
    public IGuiScrollbar setFaceColor(int color) {
        this.faceColor = color;
        return this;
    }

    @Override
    public IGuiScrollbar setColors(int border, int face) {
        return this.setBorderColor(border).setFaceColor(face);
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void setDragging(boolean isDragging) {
        this.dragging = isDragging;
    }
}

