/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class ParticleWings
extends Particle {
    private float fadeTargetRed;
    private float fadeTargetGreen;
    private float fadeTargetBlue;
    private boolean fadingColor;
    private float baseAirFriction = 0.91f;

    public ParticleWings(World world, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.particleScale *= 0.3f;
        this.particleMaxAge = 50 + this.rand.nextInt(12);
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setExpired();
        }
        if (this.particleAge > this.particleMaxAge / 2) {
            this.setAlphaF(1.0f - ((float)this.particleAge - (float)(this.particleMaxAge / 2)) / (float)this.particleMaxAge);
            if (this.fadingColor) {
                this.particleRed += (this.fadeTargetRed - this.particleRed) * 0.2f;
                this.particleGreen += (this.fadeTargetGreen - this.particleGreen) * 0.2f;
                this.particleBlue += (this.fadeTargetBlue - this.particleBlue) * 0.2f;
            }
        }
        this.setParticleTextureIndex(160 + (7 - this.particleAge * 8 / this.particleMaxAge));
        this.motionY -= (double)0.004f;
        this.move(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)this.baseAirFriction;
        this.motionY *= (double)this.baseAirFriction;
        this.motionZ *= (double)this.baseAirFriction;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
        if (this.particleAge < this.particleMaxAge / 2 && (this.particleAge + this.particleMaxAge) % 2 == 0) {
            ParticleWings particlefirework$spark = new ParticleWings(this.world, this.posX, this.posY, this.posZ);
            particlefirework$spark.setAlphaF(0.99f);
            particlefirework$spark.setRBGColorF(this.particleRed, this.particleGreen, this.particleBlue);
            particlefirework$spark.particleAge = particlefirework$spark.particleMaxAge / 2;
            Minecraft.getMinecraft().effectRenderer.addEffect((Particle)particlefirework$spark);
        }
    }

    public void renderParticle(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (entityIn.isInvisible()) {
            return;
        }
        if (this.particleAge < this.particleMaxAge / 3 || (this.particleAge + this.particleMaxAge) / 3 % 2 == 0) {
            super.renderParticle(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
        }
    }

    public boolean shouldDisableDepth() {
        return true;
    }

    public int getBrightnessForRender(float p_189214_1_) {
        return 0xF000F0;
    }
}

