/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.client.render;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.client.model.ModelContributorWings;
import p455w0rdslib.client.particle.ParticleWings;
import p455w0rdslib.math.Pos3D;
import p455w0rdslib.util.ContributorUtils;
import p455w0rdslib.util.EasyMappings;
import p455w0rdslib.util.RenderUtils;

@SideOnly(value=Side.CLIENT)
public class LayerContributorWings
implements LayerRenderer<AbstractClientPlayer> {
    private final ModelContributorWings modelWings = new ModelContributorWings();

    public void doRenderLayer(AbstractClientPlayer clientPlayer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        boolean isPlayerSelf;
        AbstractClientPlayer player;
        if (!ContributorUtils.isContributor(clientPlayer) || !LibGlobals.ConfigOptions.ENABLE_CONTRIB_CAPE && clientPlayer.getUniqueID().equals(EasyMappings.player().getUniqueID())) {
            return;
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
        RenderUtils.bindTexture(new ResourceLocation("p455w0rdslib", ContributorUtils.getWingType(clientPlayer).getTexture()));
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)0.0, (double)-0.025f, (double)0.075f);
        GlStateManager.scale((double)0.5, (double)0.5, (double)0.5);
        this.modelWings.setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, (Entity)clientPlayer);
        this.modelWings.render((Entity)clientPlayer, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        if (ContributorUtils.isPlayerSpecial(clientPlayer.getUniqueID())) {
            LayerContributorWings.renderEnchantedGlint(RenderUtils.getRenderPlayer(clientPlayer), (EntityLivingBase)clientPlayer, this.modelWings, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, ContributorUtils.getWingType(clientPlayer));
        }
        if (Minecraft.getMinecraft().gameSettings.particleSetting == 0 && clientPlayer instanceof EntityPlayer && (!(player = clientPlayer).getUniqueID().equals(Minecraft.getMinecraft().player.getUniqueID()) || Minecraft.getMinecraft().gameSettings.thirdPersonView != 0) && ContributorUtils.isPlayerSuperSpecial(player.getUniqueID().toString()) && ((isPlayerSelf = player.getUniqueID().equals(Minecraft.getMinecraft().player.getUniqueID())) && LibGlobals.ConfigOptions.ENABLE_CONTRIB_PARTICLES_SELF || !isPlayerSelf && LibGlobals.ConfigOptions.ENABLE_CONTRIB_PARTICLES_OTHERS) && player.getEntityWorld() != null && player.getEntityWorld().rand.nextInt(101) <= 5) {
            Pos3D userPos = new Pos3D((Entity)player).translate(0.0, 1.8, 0.0);
            float rnga = player.getEntityWorld().rand.nextFloat();
            float rngb = 0.0f - player.getEntityWorld().rand.nextFloat();
            float rng = rnga + rngb;
            float yheight = -0.5f;
            Pos3D vLeft = new Pos3D(rng, (double)(yheight -= Math.abs(rng) / 4.5f) + 0.12, -0.25).rotatePitch(0.0f).rotateYaw(player.renderYawOffset);
            Pos3D v = userPos.translate(vLeft).translate(new Pos3D(player.motionX, player.motionY, player.motionZ).scale(0.5));
            ParticleManager pm = Minecraft.getMinecraft().effectRenderer;
            if (player.isSneaking()) {
                v = new Pos3D(v.x, v.y - 0.5, v.z);
            }
            ParticleWings particle = new ParticleWings(player.getEntityWorld(), v.x, v.y, v.z);
            if (ContributorUtils.getWingType(player.getUniqueID().toString()) == Type.RAINBOW) {
                particle.setRBGColorF((float)LibGlobals.RED / 255.0f, (float)LibGlobals.GREEN / 255.0f, (float)LibGlobals.BLUE / 255.0f);
            } else {
                Color color = ContributorUtils.getWingType(player.getUniqueID().toString()).getParticleColor();
                particle.setRBGColorF((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
            particle.setAlphaF(1.0f);
            particle.setMaxAge(24);
            pm.addEffect((Particle)particle);
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    public static void renderEnchantedGlint(RenderLivingBase<?> p_188364_0_, EntityLivingBase p_188364_1_, ModelBase model, float p_188364_3_, float p_188364_4_, float p_188364_5_, float p_188364_6_, float p_188364_7_, float p_188364_8_, float p_188364_9_, Type type) {
        float f = (float)p_188364_1_.ticksExisted + p_188364_5_;
        Color color = type.getColor();
        if (color == null) {
            color = new Color(LibGlobals.RED, LibGlobals.GREEN, LibGlobals.BLUE, 255);
        }
        p_188364_0_.bindTexture(new ResourceLocation("textures/misc/enchanted_item_glint.png"));
        GlStateManager.enableBlend();
        GlStateManager.depthFunc((int)514);
        GlStateManager.depthMask((boolean)false);
        float f1 = 0.5f;
        GlStateManager.color((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.disableLighting();
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.color((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
            GlStateManager.matrixMode((int)5890);
            GlStateManager.loadIdentity();
            float f3 = 0.33333334f;
            GlStateManager.scale((float)0.33333334f, (float)0.33333334f, (float)0.33333334f);
            GlStateManager.rotate((float)(30.0f - (float)i * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.translate((float)0.0f, (float)(f * (0.001f + (float)i * 0.003f) * 20.0f), (float)0.0f);
            GlStateManager.matrixMode((int)5888);
            model.render((Entity)p_188364_1_, p_188364_3_, p_188364_4_, p_188364_6_, p_188364_7_, p_188364_8_, p_188364_9_);
        }
        GlStateManager.matrixMode((int)5890);
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.enableLighting();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.depthFunc((int)515);
        GlStateManager.disableBlend();
    }

    public boolean shouldCombineTextures() {
        return false;
    }

    public static enum Type {
        EMERALD("textures/models/wings.png", new Color(-15230611), new Color(-15204499), "_EWINGS"),
        BLOOD("textures/models/wings_r.png", new Color(170, 0, 0, 255), "_RWINGS"),
        BLOOD2("textures/models/wings_r2.png", new Color(128, 0, 0, 255), "_RWINGS2"),
        BLUE("textures/models/wings_b.png", new Color(0.5f, 0.25f, 0.75f, 1.0f), "_BWINGS"),
        XMAS("textures/models/wings_xmas.png", new Color(-8355712), "_XMAS"),
        PURPLE("textures/models/wings_p.png", new Color(148, 3, 221, 255), "_PURPLE"),
        PURPLE2("textures/models/wings_p2.png", new Color(148, 3, 221, 255), "_PURPLE2"),
        GOLD("textures/models/wings_g.png", new Color(-464380), "_GOLD"),
        SIVER("textures/models/wings_silver.png", new Color(-1), "_SILVER"),
        RAINBOW("textures/models/wings_silver.png", null, "_RAINBOW"),
        CARBON("textures/models/wings.png", new Color(0.5f, 0.25f, 0.75f, 1.0f), "_CARBON");

        String textureLoc;
        String identifier;
        Color color;
        Color particleColor;

        private Type(String texture, Color colorIn, String ident) {
            this(texture, colorIn, colorIn, ident);
        }

        private Type(String texture, Color colorIn, Color particleColorIn, String ident) {
            this.textureLoc = texture;
            this.color = colorIn;
            this.identifier = ident;
            this.particleColor = particleColorIn;
        }

        public String getTexture() {
            return this.textureLoc;
        }

        public Color getColor() {
            return this.color;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Color getParticleColor() {
            return this.particleColor;
        }
    }
}

