/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.math;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import p455w0rdslib.util.MathUtils;

public class Pos3D
extends Vec3d {
    public Pos3D() {
        this(0.0, 0.0, 0.0);
    }

    public Pos3D(Vec3d vec) {
        super(vec.x, vec.y, vec.z);
    }

    public Pos3D(Vec3i vec) {
        super(vec);
    }

    public Pos3D(RayTraceResult mop) {
        this((Vec3i)mop.getBlockPos());
    }

    public Pos3D(double x, double y, double z) {
        super(x, y, z);
    }

    public Pos3D(Entity entity) {
        this(entity.posX, entity.posY, entity.posZ);
    }

    public Pos3D(TileEntity tileEntity) {
        this((Vec3i)tileEntity.getPos());
    }

    public static Pos3D read(NBTTagCompound tag) {
        return new Pos3D(tag.getDouble("x"), tag.getDouble("y"), tag.getDouble("z"));
    }

    public NBTTagCompound write(NBTTagCompound nbtTags) {
        nbtTags.setDouble("x", this.x);
        nbtTags.setDouble("y", this.y);
        nbtTags.setDouble("z", this.z);
        return nbtTags;
    }

    public Pos3D diff(Vec3d vec) {
        return new Pos3D(this.x - vec.x, this.y - vec.y, this.z - vec.z);
    }

    public static Pos3D fromMotion(Entity entity) {
        return new Pos3D(entity.motionX, entity.motionY, entity.motionZ);
    }

    public Pos3D centre() {
        return this.translate(0.5, 0.5, 0.5);
    }

    public Pos3D translate(double xx, double yy, double zz) {
        return new Pos3D(xx + this.x, yy + this.y, zz + this.z);
    }

    public Pos3D translate(Vec3d pos) {
        return this.translate(pos.x, pos.y, pos.z);
    }

    public Pos3D translate(EnumFacing direction, double amount) {
        return this.translate((double)direction.getDirectionVec().getX() * amount, (double)direction.getDirectionVec().getY() * amount, (double)direction.getDirectionVec().getZ() * amount);
    }

    public Pos3D translateExcludingSide(EnumFacing direction, double amount) {
        double xPos = this.x;
        double yPos = this.y;
        double zPos = this.z;
        if (direction.getAxis() != EnumFacing.Axis.X) {
            xPos += amount;
        }
        if (direction.getAxis() != EnumFacing.Axis.Y) {
            yPos += amount;
        }
        if (direction.getAxis() != EnumFacing.Axis.Z) {
            zPos += amount;
        }
        return new Pos3D(xPos, yPos, zPos);
    }

    public double distance(Vec3d pos) {
        double subX = this.x - pos.x;
        double subY = this.y - pos.y;
        double subZ = this.z - pos.z;
        return MathUtils.sqrt(subX * subX + subY * subY + subZ * subZ);
    }

    public Pos3D rotateYaw(float yaw) {
        double yawRadians = Math.toRadians(yaw);
        double xPos = this.x;
        double zPos = this.z;
        if (yaw != 0.0f) {
            xPos = this.x * Math.cos(yawRadians) - this.z * Math.sin(yawRadians);
            zPos = this.z * Math.cos(yawRadians) + this.x * Math.sin(yawRadians);
        }
        return new Pos3D(xPos, this.y, zPos);
    }

    public Pos3D rotatePitch(float pitch) {
        double pitchRadians = Math.toRadians(pitch);
        double yPos = this.y;
        double zPos = this.z;
        if (pitch != 0.0f) {
            yPos = this.y * Math.cos(pitchRadians) - this.z * Math.sin(pitchRadians);
            zPos = this.z * Math.cos(pitchRadians) + this.y * Math.sin(pitchRadians);
        }
        return new Pos3D(this.x, yPos, zPos);
    }

    public Pos3D rotate(float yaw, float pitch) {
        return this.rotate(yaw, pitch, 0.0f);
    }

    public Pos3D rotate(float yaw, float pitch, float roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double xPos = this.x;
        double yPos = this.y;
        double zPos = this.z;
        xPos = this.x * Math.cos(yawRadians) * Math.cos(pitchRadians) + this.z * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + this.y * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        zPos = this.x * Math.sin(yawRadians) * Math.cos(pitchRadians) + this.z * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + this.y * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        yPos = -this.x * Math.sin(pitchRadians) + this.z * Math.cos(pitchRadians) * Math.sin(rollRadians) + this.y * Math.cos(pitchRadians) * Math.cos(rollRadians);
        return new Pos3D(xPos, yPos, zPos);
    }

    public Pos3D multiply(Vec3d pos) {
        return this.scale(pos.x, pos.y, pos.z);
    }

    public Pos3D scale(double xx, double yy, double zz) {
        return new Pos3D(xx * this.x, yy * this.y, zz * this.z);
    }

    public Pos3D scale(double scale) {
        return this.scale(scale, scale, scale);
    }

    public Pos3D rotate(float angle, Pos3D axis) {
        return Pos3D.translateMatrix(Pos3D.getRotationMatrix(angle, axis), this);
    }

    public double[] getRotationMatrix(float angle) {
        double[] matrix = new double[16];
        Pos3D axis = this.clone().normalize();
        double x = axis.x;
        double y = axis.y;
        double z = axis.z;
        angle = (float)((double)angle * 0.0174532925);
        float cos = (float)Math.cos(angle);
        float ocos = 1.0f - cos;
        float sin = (float)Math.sin(angle);
        matrix[0] = x * x * (double)ocos + (double)cos;
        matrix[1] = y * x * (double)ocos + z * (double)sin;
        matrix[2] = x * z * (double)ocos - y * (double)sin;
        matrix[4] = x * y * (double)ocos - z * (double)sin;
        matrix[5] = y * y * (double)ocos + (double)cos;
        matrix[6] = y * z * (double)ocos + x * (double)sin;
        matrix[8] = x * z * (double)ocos + y * (double)sin;
        matrix[9] = y * z * (double)ocos - x * (double)sin;
        matrix[10] = z * z * (double)ocos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public static Pos3D translateMatrix(double[] matrix, Pos3D translation) {
        double x = translation.x * matrix[0] + translation.y * matrix[1] + translation.z * matrix[2] + matrix[3];
        double y = translation.x * matrix[4] + translation.y * matrix[5] + translation.z * matrix[6] + matrix[7];
        double z = translation.x * matrix[8] + translation.y * matrix[9] + translation.z * matrix[10] + matrix[11];
        return new Pos3D(x, y, z);
    }

    public static double[] getRotationMatrix(float angle, Pos3D axis) {
        return axis.getRotationMatrix(angle);
    }

    public double anglePreNorm(Pos3D pos2) {
        return Math.acos(this.dotProduct(pos2));
    }

    public static double anglePreNorm(Pos3D pos1, Pos3D pos2) {
        return Math.acos(pos1.clone().dotProduct(pos2));
    }

    public Pos3D normalize() {
        return new Pos3D(super.normalize());
    }

    public Pos3D xCrossProduct() {
        return new Pos3D(0.0, this.z, -this.y);
    }

    public Pos3D zCrossProduct() {
        return new Pos3D(-this.y, this.x, 0.0);
    }

    public Pos3D getPerpendicular() {
        if (this.z == 0.0) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public Pos3D floor() {
        return new Pos3D(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public static AxisAlignedBB getAABB(Pos3D pos1, Pos3D pos2) {
        return new AxisAlignedBB(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public Pos3D clone() {
        return new Pos3D(this.x, this.y, this.z);
    }

    public String toString() {
        return "[Pos3D: " + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Vec3d && ((Vec3d)obj).x == this.x && ((Vec3d)obj).x == this.y && ((Vec3d)obj).x == this.z;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + new Double(this.x).hashCode();
        code = 31 * code + new Double(this.y).hashCode();
        code = 31 * code + new Double(this.z).hashCode();
        return code;
    }
}

