/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.LogManager;

public class BlockUtils {
    public static IBlockState getAdjacentBlock(World world, BlockPos pos, EnumFacing facing) {
        pos = pos.offset(facing);
        return world == null || !world.isBlockLoaded(pos) ? Blocks.AIR.getDefaultState() : world.getBlockState(pos);
    }

    public static IBlockState getAdjacentBlock(World world, BlockPos pos, int side) {
        return world == null ? Blocks.AIR.getDefaultState() : BlockUtils.getAdjacentBlock(world, pos, EnumFacing.VALUES[side]);
    }

    public static List<IBlockState> getAdjacentBlocks(World world, BlockPos pos) {
        ArrayList blockList = Lists.newArrayList();
        for (EnumFacing facing : EnumFacing.VALUES) {
            blockList.add(BlockUtils.getAdjacentBlock(world, pos, facing));
        }
        return blockList;
    }

    public static List<IBlockState> getAdjacentHorizontalBlocks(World world, BlockPos pos) {
        ArrayList blockList = Lists.newArrayList();
        for (EnumFacing facing : EnumFacing.HORIZONTALS) {
            blockList.add(world == null ? Blocks.AIR.getDefaultState() : BlockUtils.getAdjacentBlock(world, pos, facing));
        }
        return blockList;
    }

    public static IBlockState resolveBlockState(ResourceLocation name, Map<String, String> properties) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(name);
        if (block == null || block == Blocks.AIR) {
            return Blocks.AIR.getDefaultState();
        }
        IBlockState state = block.getDefaultState();
        if (properties != null) {
            Collection blockProperties = state.getPropertyKeys();
            block0: for (Map.Entry<String, String> entry : properties.entrySet()) {
                String serializedKey = entry.getKey();
                String serializedValue = entry.getValue();
                for (IProperty property : blockProperties) {
                    if (!Objects.equals(property.getName(), serializedKey)) continue;
                    Comparable originalValue = state.getValue(property);
                    while (!Objects.equals(property.getName(state.getValue(property)), serializedValue)) {
                        if (!Objects.equals((state = state.cycleProperty(property)).getValue(property), originalValue)) continue;
                        LogManager.getLogger((String)"p455w0rdslib").warn("Cannot parse property value '{}' for property '{}' of block {}.", (Object)serializedValue, (Object)serializedKey, (Object)name);
                        return Blocks.AIR.getDefaultState();
                    }
                    continue block0;
                }
                LogManager.getLogger((String)"p455w0rdslib").warn("Block {} has no property '{}'.", (Object)name, (Object)serializedKey);
                return Blocks.AIR.getDefaultState();
            }
        }
        return state;
    }
}

