/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import p455w0rdslib.capabilities.CapabilityChunkLoader;

public class ChunkUtils {
    private ChunkUtils() {
    }

    public static long serializeChunkPos(ChunkPos chunk) {
        return chunk.x & 0xFFFFFFFF | (chunk.z & 0xFFFFFFFF) << 32;
    }

    public static ChunkPos deserializeChunkPos(long value) {
        return new ChunkPos((int)(value & 0xFFFFFFFFFFFFFFFFL), (int)(value >> 32));
    }

    public static void register(Object modInstance) {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)modInstance, (ForgeChunkManager.LoadingCallback)Callback.getInstance());
    }

    public static ChunkPos getChunkPos(World world, BlockPos pos) {
        return world.getChunkFromBlockCoords(pos).getPos();
    }

    public static class TicketHandler {
        private static final TicketHandler INSTANCE = new TicketHandler();

        private TicketHandler() {
        }

        public static TicketHandler getInstance() {
            return INSTANCE;
        }

        public ForgeChunkManager.Ticket getTicket(Object modInstnace, World world) {
            return ForgeChunkManager.requestTicket((Object)modInstnace, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }

        public void load(World world, BlockPos pos, ForgeChunkManager.Ticket ticket) {
            if (world != null && !world.isRemote && pos != null && !ForgeChunkManager.getPersistentChunksFor((World)world).containsKey((Object)ChunkUtils.getChunkPos(world, pos))) {
                ticket.getModData().setInteger("xCoord", pos.getX());
                ticket.getModData().setInteger("yCoord", pos.getY());
                ticket.getModData().setInteger("zCoord", pos.getZ());
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)ChunkUtils.getChunkPos(world, pos));
            }
        }

        public void unload(World world, BlockPos pos, ForgeChunkManager.Ticket ticket) {
            if (world != null && !world.isRemote && pos != null && ForgeChunkManager.getPersistentChunksFor((World)world).containsKey((Object)ChunkUtils.getChunkPos(world, pos))) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)ChunkUtils.getChunkPos(world, pos));
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        }
    }

    public static class Callback
    implements ForgeChunkManager.LoadingCallback {
        private static final Callback INSTANCE = new Callback();

        private Callback() {
        }

        public static Callback getInstance() {
            return INSTANCE;
        }

        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int z;
                int y;
                int x = ticket.getModData().getInteger("xCoord");
                BlockPos pos = new BlockPos(x, y = ticket.getModData().getInteger("yCoord"), z = ticket.getModData().getInteger("zCoord"));
                TileEntity te = world.getTileEntity(pos);
                if (te == null || !te.hasCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)) continue;
                TicketHandler handler = new TicketHandler();
                FMLCommonHandler.instance().getMinecraftServerInstance().addScheduledTask(() -> handler.load(world, pos, ticket));
            }
        }
    }
}

