/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rdslib.util.EasyMappings;
import p455w0rdslib.util.MCUtils;
import p455w0rdslib.util.RenderUtils;

@SideOnly(value=Side.CLIENT)
public class GuiUtils {
    private static Minecraft mc() {
        return MCUtils.mc();
    }

    public static void bindTexture(String texturePath) {
        GuiUtils.bindTexture(new ResourceLocation(texturePath));
    }

    public static void bindTexture(String domain, String texturePath) {
        GuiUtils.bindTexture(new ResourceLocation(domain, texturePath));
    }

    public static void bindTexture(ResourceLocation location) {
        RenderUtils.getTextureManager().bindTexture(location);
    }

    public static void drawItem(ItemStack item, int x, int y) {
        RenderHelper.enableGUIStandardItemLighting();
        RenderUtils.getRenderItem().renderItemAndEffectIntoGUI(item, x, y);
        RenderHelper.disableStandardItemLighting();
    }

    public static void drawFluid(Gui gui, int x, int y, FluidStack fluid, int width, int height) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        GuiUtils.setBlockTextureSheet();
        int colour = fluid.getFluid().getColor(fluid);
        GlStateManager.color((float)(colour >> 16 & 0xFF), (float)(colour >> 8 & 0xFF), (float)(colour & 0xFF), (float)(colour >> 24 & 0xFF));
        GuiUtils.drawTiledTexture(gui, x, y, GuiUtils.getFluidTexture(fluid), width, height);
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid) {
        if (fluid == null) {
            fluid = FluidRegistry.LAVA;
        }
        return GuiUtils.getTexture(fluid.getStill());
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null || fluid.getFluid().getStill(fluid) == null) {
            fluid = new FluidStack(FluidRegistry.LAVA, 1);
        }
        return GuiUtils.getTexture(fluid.getFluid().getStill(fluid));
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return GuiUtils.getTexture(location.toString());
    }

    public static TextureAtlasSprite getTexture(String location) {
        return GuiUtils.textureMap().getAtlasSprite(location);
    }

    public static TextureMap textureMap() {
        return GuiUtils.mc().getTextureMapBlocks();
    }

    public static void setBlockTextureSheet() {
        GuiUtils.bindTexture(new ResourceLocation("textures/atlas/blocks.png"));
    }

    public static void drawTiledTexture(Gui gui, int x, int y, TextureAtlasSprite icon, int width, int height) {
        int i = 0;
        int j = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        for (i = 0; i < width; i += 16) {
            for (j = 0; j < height; j += 16) {
                drawWidth = Math.min(width - i, 16);
                drawHeight = Math.min(height - j, 16);
                GuiUtils.drawScaledTexturedModelRectFromIcon(gui, x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawScaledTexturedModelRectFromIcon(Gui gui, int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        double minU = icon.getMinU();
        double maxU = icon.getMaxU();
        double minV = icon.getMinV();
        double maxV = icon.getMaxV();
        BufferBuilder buffer = Tessellator.getInstance().getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        buffer.pos((double)(x + 0), (double)(y + height), (double)gui.zLevel).tex(minU, minV + (maxV - minV) * (double)height / 16.0).endVertex();
        buffer.pos((double)(x + width), (double)(y + height), (double)gui.zLevel).tex(minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0).endVertex();
        buffer.pos((double)(x + width), (double)(y + 0), (double)gui.zLevel).tex(minU + (maxU - minU) * (double)width / 16.0, minV).endVertex();
        buffer.pos((double)(x + 0), (double)(y + 0), (double)gui.zLevel).tex(minU, minV).endVertex();
        Tessellator.getInstance().draw();
    }

    public static void drawVanillaTooltip(GuiScreen gui, List<String> text, int x, int y) {
        GuiUtils.drawHoveringText(gui, text, x, y, RenderUtils.getFontRenderer(), -267386864, 0x505000FF, 1344798847);
    }

    public static void drawToolTipWithBorderColor(GuiScreen gui, List<String> text, int x, int y, int borderColor1, int borderColor2) {
        GuiUtils.drawHoveringText(gui, text, x, y, RenderUtils.getFontRenderer(), -267386864, borderColor1, borderColor2);
    }

    public static void drawContinuousTexturedBox(Gui gui, ResourceLocation res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int borderSize) {
        GuiUtils.drawContinuousTexturedBox(gui, res, x, y, u, v, width, height, textureWidth, textureHeight, borderSize, borderSize, borderSize, borderSize);
    }

    public static void drawContinuousTexturedBox(Gui gui, ResourceLocation res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder) {
        GuiUtils.bindTexture(res);
        GuiUtils.drawContinuousTexturedBox(gui, x, y, u, v, width, height, textureWidth, textureHeight, topBorder, bottomBorder, leftBorder, rightBorder);
    }

    public static void drawContinuousTexturedBox(Gui gui, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder) {
        float zLevel = gui.zLevel;
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        GuiUtils.drawTexturedModalRect(x, y, u, v, leftBorder, topBorder, zLevel);
        GuiUtils.drawTexturedModalRect(x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        GuiUtils.drawTexturedModalRect(x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        GuiUtils.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GuiUtils.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            GuiUtils.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GuiUtils.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GuiUtils.drawTexturedModalRect(x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            GuiUtils.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder wr = tessellator.getBuffer();
        wr.begin(7, DefaultVertexFormats.POSITION_TEX);
        wr.pos((double)x, (double)(y + height), (double)zLevel).tex((double)((float)u * 0.00390625f), (double)((float)(v + height) * 0.00390625f)).endVertex();
        wr.pos((double)(x + width), (double)(y + height), (double)zLevel).tex((double)((float)(u + width) * 0.00390625f), (double)((float)(v + height) * 0.00390625f)).endVertex();
        wr.pos((double)(x + width), (double)y, (double)zLevel).tex((double)((float)(u + width) * 0.00390625f), (double)((float)v * 0.00390625f)).endVertex();
        wr.pos((double)x, (double)y, (double)zLevel).tex((double)((float)u * 0.00390625f), (double)((float)v * 0.00390625f)).endVertex();
        tessellator.draw();
    }

    private static void drawHoveringText(GuiScreen gui, List<String> textLines, int x, int y, FontRenderer font, int backgroundColor, int borderColor1, int borderColor2) {
        if (!textLines.isEmpty()) {
            GlStateManager.pushMatrix();
            GlStateManager.disableRescaleNormal();
            RenderHelper.disableStandardItemLighting();
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            GlStateManager.enableAlpha();
            GlStateManager.disableDepth();
            int i = 0;
            for (String s : textLines) {
                int j = RenderUtils.getFontRenderer().getStringWidth(s);
                if (j <= i) continue;
                i = j;
            }
            int l1 = x + 12;
            int i2 = y - 12;
            int k = 8;
            if (textLines.size() > 1) {
                k += 2 + (textLines.size() - 1) * 10;
            }
            if (l1 + i > gui.width) {
                l1 -= 28 + i;
            }
            if (i2 + k + 8 > gui.height) {
                i2 = gui.height - k - 8;
            }
            gui.zLevel = 300.0f;
            gui.itemRender.zLevel = 300.0f;
            GuiUtils.drawGradientRect((Gui)gui, l1 - 3, i2 - 4, l1 + i + 3, i2 - 3, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect((Gui)gui, l1 - 3, i2 + k + 3, l1 + i + 3, i2 + k + 4, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect((Gui)gui, l1 - 3, i2 - 3, l1 + i + 3, i2 + k + 3, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect((Gui)gui, l1 - 4, i2 - 3, l1 - 3, i2 + k + 3, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect((Gui)gui, l1 + i + 3, i2 - 3, l1 + i + 4, i2 + k + 3, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect((Gui)gui, l1 - 3, i2 - 3 + 1, l1 - 3 + 1, i2 + k + 3 - 1, borderColor1, borderColor2);
            GuiUtils.drawGradientRect((Gui)gui, l1 + i + 2, i2 - 3 + 1, l1 + i + 3, i2 + k + 3 - 1, borderColor1, borderColor2);
            GuiUtils.drawGradientRect((Gui)gui, l1 - 3, i2 - 3, l1 + i + 3, i2 - 3 + 1, borderColor1, borderColor1);
            GuiUtils.drawGradientRect((Gui)gui, l1 - 3, i2 + k + 2, l1 + i + 3, i2 + k + 3, borderColor2, borderColor2);
            for (int k1 = 0; k1 < textLines.size(); ++k1) {
                String s1 = textLines.get(k1);
                RenderUtils.getFontRenderer().drawStringWithShadow(s1, (float)l1, (float)i2, -1);
                if (k1 == 0) {
                    i2 += 2;
                }
                i2 += 10;
            }
            gui.zLevel = 0.0f;
            gui.itemRender.zLevel = 0.0f;
            GlStateManager.enableLighting();
            GlStateManager.enableDepth();
            RenderHelper.enableStandardItemLighting();
            GlStateManager.enableRescaleNormal();
            GlStateManager.popMatrix();
        }
    }

    public static void drawCenteredString(String text, int x, int y, int color) {
        RenderUtils.getFontRenderer().drawStringWithShadow(text, (float)(x - RenderUtils.getFontRenderer().getStringWidth(text) / 2), (float)y, color);
    }

    public static void drawScaledString(String text, int x, int y, float scale, int color) {
        GlStateManager.pushMatrix();
        GlStateManager.scale((float)scale, (float)scale, (float)scale);
        RenderUtils.getFontRenderer().drawStringWithShadow(text, (float)x, (float)y, color);
        GlStateManager.popMatrix();
    }

    public static void drawStringNoShadow(String text, int x, int y, int color) {
        RenderUtils.getFontRenderer().drawString(text, (float)x, (float)y, color, false);
    }

    public static void drawGradientRect(Gui gui, int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.disableAlpha();
        GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexbuffer = tessellator.getBuffer();
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_COLOR);
        vertexbuffer.pos((double)right, (double)top, (double)gui.zLevel).color(f1, f2, f3, f).endVertex();
        vertexbuffer.pos((double)left, (double)top, (double)gui.zLevel).color(f1, f2, f3, f).endVertex();
        vertexbuffer.pos((double)left, (double)bottom, (double)gui.zLevel).color(f5, f6, f7, f4).endVertex();
        vertexbuffer.pos((double)right, (double)bottom, (double)gui.zLevel).color(f5, f6, f7, f4).endVertex();
        tessellator.draw();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.enableTexture2D();
    }

    public static void drawSlot(GuiContainer gui, Slot slotIn) {
        TextureAtlasSprite textureatlassprite;
        int i = EasyMappings.slotPosX(slotIn);
        int j = EasyMappings.slotPosY(slotIn);
        ItemStack itemstack = slotIn.getStack();
        boolean flag = false;
        boolean flag1 = slotIn == gui.clickedSlot && gui.draggedStack != null && !gui.isRightMouseClick;
        ItemStack itemstack1 = EasyMappings.player().inventory.getItemStack();
        String s = null;
        if (slotIn == gui.clickedSlot && gui.draggedStack != null && gui.isRightMouseClick && itemstack != null) {
            itemstack = itemstack.copy();
            itemstack.setCount(itemstack.getCount() / 2);
        } else if (gui.dragSplitting && gui.dragSplittingSlots.contains(slotIn) && itemstack1 != null) {
            if (gui.dragSplittingSlots.size() == 1) {
                return;
            }
            if (Container.canAddItemToSlot((Slot)slotIn, (ItemStack)itemstack1, (boolean)true) && gui.inventorySlots.canDragIntoSlot(slotIn)) {
                itemstack = itemstack1.copy();
                flag = true;
                Container.computeStackSize((Set)gui.dragSplittingSlots, (int)gui.dragSplittingLimit, (ItemStack)itemstack, (int)(slotIn.getStack() == null ? 0 : slotIn.getStack().getCount()));
                if (itemstack.getCount() > itemstack.getMaxStackSize()) {
                    s = TextFormatting.YELLOW + "" + itemstack.getMaxStackSize();
                    itemstack.setCount(itemstack.getMaxStackSize());
                }
                if (itemstack.getCount() > slotIn.getItemStackLimit(itemstack)) {
                    s = TextFormatting.YELLOW + "" + slotIn.getItemStackLimit(itemstack);
                    itemstack.setCount(slotIn.getItemStackLimit(itemstack));
                }
            } else {
                gui.dragSplittingSlots.remove(slotIn);
                GuiUtils.updateDragSplitting(gui);
            }
        }
        gui.zLevel = 100.0f;
        gui.itemRender.zLevel = 100.0f;
        if (itemstack == null && slotIn.isEnabled() && (textureatlassprite = slotIn.getBackgroundSprite()) != null) {
            GlStateManager.disableLighting();
            GuiUtils.bindTexture(slotIn.getBackgroundLocation());
            GuiUtils.drawTexturedModalRect((Gui)gui, i, j, textureatlassprite, 16, 16);
            GlStateManager.enableLighting();
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                Gui.drawRect((int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            GlStateManager.enableDepth();
            Minecraft.getMinecraft().getRenderItem().renderItemAndEffectIntoGUI(itemstack, i, j);
            gui.itemRender.renderItemOverlayIntoGUI(RenderUtils.getFontRenderer(), itemstack, i, j, s);
        }
        gui.zLevel = 0.0f;
        gui.itemRender.zLevel = 0.0f;
    }

    public static void drawTexturedModalRect(Gui gui, int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexbuffer = tessellator.getBuffer();
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexbuffer.pos((double)(xCoord + 0), (double)(yCoord + heightIn), (double)gui.zLevel).tex((double)textureSprite.getMinU(), (double)textureSprite.getMaxV()).endVertex();
        vertexbuffer.pos((double)(xCoord + widthIn), (double)(yCoord + heightIn), (double)gui.zLevel).tex((double)textureSprite.getMaxU(), (double)textureSprite.getMaxV()).endVertex();
        vertexbuffer.pos((double)(xCoord + widthIn), (double)(yCoord + 0), (double)gui.zLevel).tex((double)textureSprite.getMaxU(), (double)textureSprite.getMinV()).endVertex();
        vertexbuffer.pos((double)(xCoord + 0), (double)(yCoord + 0), (double)gui.zLevel).tex((double)textureSprite.getMinU(), (double)textureSprite.getMinV()).endVertex();
        tessellator.draw();
    }

    public static void updateDragSplitting(GuiContainer gui) {
        ItemStack itemstack = EasyMappings.player().inventory.getItemStack();
        if (itemstack != null && gui.dragSplitting) {
            gui.dragSplittingRemnant = itemstack.getCount();
            for (Slot slot : gui.dragSplittingSlots) {
                ItemStack itemstack1 = itemstack.copy();
                int i = slot.getStack() == null ? 0 : slot.getStack().getCount();
                Container.computeStackSize((Set)gui.dragSplittingSlots, (int)gui.dragSplittingLimit, (ItemStack)itemstack1, (int)i);
                if (itemstack1.getCount() > itemstack1.getMaxStackSize()) {
                    itemstack1.setCount(itemstack1.getMaxStackSize());
                }
                if (itemstack1.getCount() > slot.getItemStackLimit(itemstack1)) {
                    itemstack1.setCount(slot.getItemStackLimit(itemstack1));
                }
                gui.dragSplittingRemnant -= itemstack1.getCount() - i;
            }
        }
    }

    public static void drawItemStack(GuiContainer gui, ItemStack stack, int x, int y, String altText) {
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)32.0f);
        gui.zLevel = 200.0f;
        gui.itemRender.zLevel = 200.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.getItem().getFontRenderer(stack);
        }
        if (font == null) {
            font = RenderUtils.getFontRenderer();
        }
        gui.itemRender.renderItemAndEffectIntoGUI(stack, x, y);
        gui.itemRender.renderItemOverlayIntoGUI(font, stack, x, y - (gui.draggedStack == null ? 0 : 8), altText);
        gui.zLevel = 0.0f;
        gui.itemRender.zLevel = 0.0f;
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)-32.0f);
    }

    public static Slot getSlotAtPos(int x, int y) {
        if (Minecraft.getMinecraft().currentScreen instanceof GuiContainer) {
            GuiContainer gui = (GuiContainer)Minecraft.getMinecraft().currentScreen;
            for (int i = 0; i < gui.inventorySlots.inventorySlots.size(); ++i) {
                Slot slot = (Slot)gui.inventorySlots.inventorySlots.get(i);
                int rectX = slot.xPos;
                int rectY = slot.yPos;
                int pointX = x;
                int pointY = y;
                int i2 = gui.getGuiLeft();
                int j2 = gui.getGuiTop();
                if ((pointX -= i2) < rectX - 1 || pointX >= rectX + 16 + 1 || (pointY -= j2) < rectY - 1 || pointY >= rectY + 16 + 1 || !slot.isEnabled()) continue;
                return slot;
            }
        }
        return null;
    }
}

