/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.io.File;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import p455w0rdslib.util.EntityUtils;
import p455w0rdslib.util.MCUtils;
import p455w0rdslib.util.PlayerUtils;
import p455w0rdslib.util.RenderUtils;

public class ImageUtils {
    public static final File IMAGE_DIR = new File(MCUtils.mc().mcDataDir, "SavedImages");

    public static void saveEntity(Entity entity, int rotX, int rotY, boolean useMouseRot) {
        if (entity == null) {
            return;
        }
        if (entity instanceof EntityLivingBase) {
            RenderUtils.pushFBO();
            AxisAlignedBB aabb = entity.getEntityBoundingBox();
            double minX = aabb.minX - entity.posX;
            double maxX = aabb.maxX - entity.posX;
            double minY = aabb.minY - entity.posY;
            double maxY = aabb.maxY - entity.posY;
            double minZ = aabb.minZ - entity.posZ;
            double maxZ = aabb.maxZ - entity.posZ;
            double minBound = Math.min(minX, Math.min(minY, minZ));
            double maxBound = Math.max(maxX, Math.max(maxY, maxZ));
            double boundLimit = Math.max(Math.abs(minBound), Math.abs(maxBound));
            GlStateManager.matrixMode((int)5889);
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            GlStateManager.ortho((double)(-boundLimit * 0.75), (double)(boundLimit * 0.75), (double)(boundLimit * 0.25), (double)(-boundLimit * 1.25), (double)-100.0, (double)100.0);
            GlStateManager.matrixMode((int)5888);
            RenderUtils.renderLivingEntity(0, 0, 1, rotX, rotY, (EntityLivingBase)entity, useMouseRot);
            GlStateManager.matrixMode((int)5889);
            GlStateManager.popMatrix();
            RenderUtils.popFBO();
            RenderUtils.saveImage();
        }
    }

    public static void saveCurrentItem() {
        ItemStack stack = PlayerUtils.getPlayer().getHeldItemMainhand();
        if (stack != null && stack.getItem() != null) {
            RenderUtils.pushFBO();
            GlStateManager.matrixMode((int)5889);
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            GlStateManager.ortho((double)0.0, (double)16.0, (double)16.0, (double)0.0, (double)-100000.0, (double)100000.0);
            GlStateManager.matrixMode((int)5888);
            FloatBuffer matrix = GLAllocation.createDirectFloatBuffer((int)16);
            matrix.clear();
            matrix.put(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
            matrix.rewind();
            RenderHelper.enableGUIStandardItemLighting();
            GlStateManager.enableRescaleNormal();
            GlStateManager.enableColorMaterial();
            GlStateManager.enableLighting();
            RenderUtils.getRenderItem().renderItemAndEffectIntoGUI(stack, 0, 0);
            GlStateManager.disableLighting();
            RenderHelper.disableStandardItemLighting();
            GlStateManager.matrixMode((int)5889);
            GlStateManager.popMatrix();
            RenderUtils.popFBO();
            RenderUtils.saveImage();
        } else if (MCUtils.mc().pointedEntity != null && MCUtils.mc().pointedEntity instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)MCUtils.mc().pointedEntity;
            EntityLivingBase entityClone = (EntityLivingBase)EntityUtils.cloneEntity((Entity)entity);
            if (entityClone == null) {
                return;
            }
            RenderUtils.pushFBO();
            AxisAlignedBB aabb = entityClone.getEntityBoundingBox();
            double minX = aabb.minX - entityClone.posX;
            double maxX = aabb.maxX - entityClone.posX;
            double minY = aabb.minY - entityClone.posY;
            double maxY = aabb.maxY - entityClone.posY;
            double minZ = aabb.minZ - entityClone.posZ;
            double maxZ = aabb.maxZ - entityClone.posZ;
            double minBound = Math.min(minX, Math.min(minY, minZ));
            double maxBound = Math.max(maxX, Math.max(maxY, maxZ));
            double boundLimit = Math.max(Math.abs(minBound), Math.abs(maxBound));
            GlStateManager.matrixMode((int)5889);
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            GlStateManager.ortho((double)(-boundLimit * 0.75), (double)(boundLimit * 0.75), (double)(boundLimit * 0.25), (double)(-boundLimit * 1.25), (double)-100.0, (double)100.0);
            GlStateManager.matrixMode((int)5888);
            ImageUtils.renderEntity(entityClone);
            GlStateManager.matrixMode((int)5889);
            GlStateManager.popMatrix();
            RenderUtils.popFBO();
            RenderUtils.saveImage();
        }
    }

    private static void renderEntity(EntityLivingBase entity) {
        GlStateManager.enableColorMaterial();
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)50.0f);
        GlStateManager.scale((float)-1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotate((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GlStateManager.rotate((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)((float)Math.toDegrees(Math.asin(Math.tan(Math.toRadians(30.0))))), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotate((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (entity instanceof EntityPig) {
            GlStateManager.scale((float)0.75f, (float)0.75f, (float)0.75f);
        }
        GlStateManager.rotate((float)(-((float)Math.atan(0.025f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = RenderUtils.getRenderManager();
        rendermanager.setPlayerViewY(90.0f);
        rendermanager.setRenderShadow(false);
        rendermanager.renderEntity((Entity)entity, 0.0, 0.0, 0.0, entity.rotationYaw, RenderUtils.getPartialTicks(), false);
        rendermanager.setRenderShadow(true);
        GlStateManager.popMatrix();
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableRescaleNormal();
        GlStateManager.setActiveTexture((int)OpenGlHelper.lightmapTexUnit);
        GlStateManager.disableTexture2D();
        GlStateManager.setActiveTexture((int)OpenGlHelper.defaultTexUnit);
    }
}

