/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import p455w0rdslib.P455w0rdsLib;
import p455w0rdslib.util.ItemUtils;

public class InventoryUtils {
    @SideOnly(value=Side.CLIENT)
    public static ItemStack getArmorPiece(EntityEquipmentSlot slot) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            EntityPlayer player = P455w0rdsLib.PROXY.getPlayer();
            NonNullList armorStack = player.inventory.armorInventory;
            int slotNum = 0;
            switch (slot) {
                case HEAD: {
                    slotNum = 3;
                    break;
                }
                case CHEST: {
                    slotNum = 2;
                    break;
                }
                case LEGS: {
                    slotNum = 1;
                    break;
                }
                default: {
                    slotNum = 0;
                }
            }
            return (ItemStack)armorStack.get(slotNum);
        }
        return ItemStack.EMPTY;
    }

    public static boolean isInHotbar(int index) {
        return index >= 0 && index <= 8;
    }

    public static boolean isInInventory(int index) {
        return index >= 9 && index <= 36;
    }

    public static boolean moveStackWithinInventory(ItemStack itemStackIn, int index, List<Slot> inventorySlots) {
        block3: {
            block2: {
                if (!InventoryUtils.isInHotbar(index)) break block2;
                for (int i = 9; i <= 36; ++i) {
                    Slot possiblyOpenSlot = inventorySlots.get(i);
                    if (possiblyOpenSlot.getHasStack()) continue;
                    possiblyOpenSlot.putStack(itemStackIn);
                    inventorySlots.get(index).putStack(ItemStack.EMPTY);
                    return true;
                }
                break block3;
            }
            if (!InventoryUtils.isInInventory(index)) break block3;
            for (int i = 0; i <= 8; ++i) {
                Slot possiblyOpenSlot = inventorySlots.get(i);
                if (possiblyOpenSlot.getHasStack()) continue;
                possiblyOpenSlot.putStack(itemStackIn);
                inventorySlots.get(index).putStack(ItemStack.EMPTY);
                return true;
            }
        }
        return false;
    }

    public static boolean moveStackToInventory(ItemStack itemStackIn, List<Slot> inventorySlots) {
        for (int i = 0; i <= 36; ++i) {
            Slot possiblyOpenSlot = inventorySlots.get(i);
            if (possiblyOpenSlot.getHasStack()) continue;
            possiblyOpenSlot.putStack(itemStackIn);
            return true;
        }
        return false;
    }

    public static int getNextAvailableSlot(List<Slot> inventorySlots) {
        for (int i = 36; i <= 63; ++i) {
            Slot s = inventorySlots.get(i);
            if (s == null || !s.getStack().isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static boolean isCustomSlot(int index, boolean withArmor, boolean withOffHand) {
        return index >= (withArmor ? 40 : (withOffHand ? 41 : 36));
    }

    public static boolean isCustomSlot(int index, boolean withArmor) {
        return InventoryUtils.isCustomSlot(index, withArmor, false);
    }

    public static boolean isCustomSlot(int index) {
        return InventoryUtils.isCustomSlot(index, false, false);
    }

    public static boolean isItemHandler(TileEntity tile) {
        return InventoryUtils.isItemHandler(tile, null);
    }

    public static boolean isItemHandler(TileEntity tile, @Nullable EnumFacing facing) {
        return tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
    }

    public static boolean isInventory(TileEntity tile) {
        return tile instanceof IInventory;
    }

    public static boolean hasItemStorage(TileEntity tile, EnumFacing facing) {
        return InventoryUtils.isItemHandler(tile, facing) || InventoryUtils.isInventory(tile);
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing facing) {
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
        }
        if (tile instanceof ISidedInventory) {
            return InventoryUtils.getWrappedInventory((IInventory)((ISidedInventory)tile), facing);
        }
        if (tile instanceof IInventory) {
            return InventoryUtils.getWrappedInventory((IInventory)tile);
        }
        return null;
    }

    public static IItemHandler getWrappedInventory(IInventory inventory) {
        return InventoryUtils.getWrappedInventory(inventory, null);
    }

    public static IItemHandler getWrappedInventory(IInventory inventory, @Nullable EnumFacing facing) {
        if (inventory instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)inventory, facing);
        }
        return new InvWrapper(inventory);
    }

    public static boolean addItemStack(ItemStack[] inventory, ItemStack stack, int startIndex, int endIndex) {
        if (stack.isEmpty()) {
            return true;
        }
        int openSlot = -1;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (ItemStack.areItemStacksEqual((ItemStack)stack, (ItemStack)inventory[i]) && inventory[i].getMaxStackSize() > inventory[i].getCount()) {
                int hold = inventory[i].getMaxStackSize() - inventory[i].getCount();
                if (hold >= stack.getCount()) {
                    inventory[i].grow(stack.getCount());
                    stack = ItemStack.EMPTY;
                    return true;
                }
                stack.shrink(hold);
                inventory[i].grow(hold);
                continue;
            }
            if (!inventory[i].isEmpty() || openSlot != -1) continue;
            openSlot = i;
        }
        if (openSlot < 0) {
            return false;
        }
        inventory[openSlot] = stack;
        return true;
    }

    public static ItemStack insertItem(IInventory inventory, ItemStack stack) {
        return InventoryUtils.insertItem(inventory, stack, null);
    }

    public static ItemStack insertItem(IInventory inventory, ItemStack stack, @Nullable EnumFacing side) {
        if (stack.isEmpty() || inventory == null) {
            return ItemStack.EMPTY;
        }
        int stackSize = stack.getCount();
        if (inventory instanceof ISidedInventory) {
            int i;
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] slots = sidedInv.getSlotsForFace(side);
            if (slots == null) {
                return stack;
            }
            for (i = 0; i < slots.length && !stack.isEmpty(); ++i) {
                ItemStack existingStack;
                if (!sidedInv.canInsertItem(slots[i], stack, side) || !ItemStack.areItemStacksEqual((ItemStack)stack, (ItemStack)(existingStack = inventory.getStackInSlot(slots[i])))) continue;
                stack = InventoryUtils.insertMergeable((IInventory)sidedInv, slots[i], stack, existingStack);
            }
            for (i = 0; i < slots.length && !stack.isEmpty(); ++i) {
                if (!inventory.getStackInSlot(slots[i]).isEmpty() || !sidedInv.canInsertItem(slots[i], stack, side)) continue;
                stack = InventoryUtils.insertEmpty((IInventory)sidedInv, slots[i], stack);
            }
        } else {
            int i;
            int invSize = inventory.getSizeInventory();
            for (i = 0; i < invSize && !stack.isEmpty(); ++i) {
                ItemStack existingStack = inventory.getStackInSlot(i);
                if (!ItemStack.areItemStacksEqual((ItemStack)stack, (ItemStack)existingStack)) continue;
                stack = InventoryUtils.insertMergeable(inventory, i, stack, existingStack);
            }
            for (i = 0; i < invSize && !stack.isEmpty(); ++i) {
                if (!inventory.getStackInSlot(i).isEmpty()) continue;
                stack = InventoryUtils.insertEmpty(inventory, i, stack);
            }
        }
        if (stack.isEmpty() || stack.getCount() != stackSize) {
            inventory.markDirty();
        }
        return stack;
    }

    public static boolean hasRoomForStack(TileEntity te, ItemStack stack) {
        if (InventoryUtils.isItemHandler(te)) {
            if (InventoryUtils.hasRoomForStack(InventoryUtils.getItemHandler(te, null), stack)) {
                return true;
            }
            for (int i = 0; i < EnumFacing.values().length; ++i) {
                if (!InventoryUtils.hasRoomForStack(InventoryUtils.getItemHandler(te, EnumFacing.values()[i]), stack)) continue;
                return true;
            }
        }
        if (InventoryUtils.isInventory(te)) {
            return InventoryUtils.hasRoomForStack((IInventory)te, stack);
        }
        return false;
    }

    public static boolean hasRoomForStack(IInventory inventory, ItemStack stack) {
        IInventory tempInventory;
        if (stack.isEmpty()) {
            return false;
        }
        Object object = tempInventory = inventory instanceof ISidedInventory ? InventoryUtils.getSidedInventoryCopy((ISidedInventory)inventory) : InventoryUtils.getInventoryCopy(inventory);
        if (!(inventory instanceof ISidedInventory)) {
            return !ItemUtils.areStacksSameSize(stack.copy(), InventoryUtils.insertItem(tempInventory, stack.copy()));
        }
        if (InventoryUtils.isInventoryValidForItem((ISidedInventory)tempInventory, stack.copy(), null)) {
            return true;
        }
        for (EnumFacing facing : EnumFacing.VALUES) {
            if (!InventoryUtils.isInventoryValidForItem((ISidedInventory)tempInventory, stack.copy(), facing)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInventoryValidForItem(ISidedInventory inv, ItemStack stack, @Nullable EnumFacing facing) {
        boolean canInsert = false;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            if (!inv.canInsertItem(i, stack, facing)) continue;
            canInsert = true;
            break;
        }
        return InventoryUtils.isInventoryValidForItem((IInventory)inv, stack) && inv.getSlotsForFace(facing).length > 0 && canInsert;
    }

    public static boolean isInventoryValidForItem(IInventory inv, ItemStack stack) {
        boolean hasAvailableSlot = false;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            if (inv.getStackInSlot(i).isEmpty() && inv.isItemValidForSlot(i, stack)) {
                hasAvailableSlot = true;
                break;
            }
            ItemStack slotStack = inv.getStackInSlot(i);
            if (!ItemStack.areItemStacksEqual((ItemStack)stack, (ItemStack)slotStack) || slotStack.getCount() >= slotStack.getMaxStackSize()) continue;
            hasAvailableSlot = true;
            break;
        }
        return hasAvailableSlot;
    }

    public static boolean isInventoryValidForItem(IItemHandler handler, ItemStack stack) {
        boolean hasAvailableSlot = false;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).isEmpty()) {
                hasAvailableSlot = true;
                break;
            }
            ItemStack slotStack = handler.getStackInSlot(i);
            if (!ItemStack.areItemStacksEqual((ItemStack)stack, (ItemStack)slotStack) || slotStack.getCount() >= slotStack.getMaxStackSize()) continue;
            hasAvailableSlot = true;
            break;
        }
        return hasAvailableSlot;
    }

    public static boolean hasRoomForStack(IItemHandler handler, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Object tempHandler = null;
        tempHandler = handler instanceof IItemHandlerModifiable ? InventoryUtils.getItemHandlerModifiableCopy((IItemHandlerModifiable)handler) : InventoryUtils.getItemHandlerCopy(handler);
        return InventoryUtils.isInventoryValidForItem(tempHandler, stack);
    }

    public static IItemHandlerModifiable getItemHandlerModifiableCopy(final IItemHandlerModifiable handler) {
        return new IItemHandlerModifiable(){

            public int getSlots() {
                return handler.getSlots();
            }

            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return handler.insertItem(slot, stack, simulate);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return handler.extractItem(slot, amount, simulate);
            }

            public void setStackInSlot(int slot, ItemStack stack) {
                handler.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }
        };
    }

    public static IItemHandler getItemHandlerCopy(final IItemHandler handler) {
        return new IItemHandler(){

            public int getSlots() {
                return handler.getSlots();
            }

            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return handler.insertItem(slot, stack, simulate);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return handler.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }
        };
    }

    public static IInventory getInventoryCopy(final IInventory inventory) {
        return new IInventory(){

            public String getName() {
                return inventory.getName();
            }

            public boolean hasCustomName() {
                return inventory.hasCustomName();
            }

            public ITextComponent getDisplayName() {
                return inventory.getDisplayName();
            }

            public int getSizeInventory() {
                return inventory.getSizeInventory();
            }

            public ItemStack getStackInSlot(int index) {
                return inventory.getStackInSlot(index);
            }

            public ItemStack decrStackSize(int index, int count) {
                return inventory.decrStackSize(index, count);
            }

            public ItemStack removeStackFromSlot(int index) {
                return inventory.removeStackFromSlot(index);
            }

            public void setInventorySlotContents(int index, ItemStack stack) {
                inventory.setInventorySlotContents(index, stack);
            }

            public int getInventoryStackLimit() {
                return inventory.getInventoryStackLimit();
            }

            public void markDirty() {
                inventory.markDirty();
            }

            public boolean isUsableByPlayer(EntityPlayer player) {
                return inventory.isUsableByPlayer(player);
            }

            public void openInventory(EntityPlayer player) {
                inventory.openInventory(player);
            }

            public void closeInventory(EntityPlayer player) {
                inventory.closeInventory(player);
            }

            public boolean isItemValidForSlot(int index, ItemStack stack) {
                return inventory.isItemValidForSlot(index, stack);
            }

            public int getField(int id) {
                return inventory.getField(id);
            }

            public void setField(int id, int value) {
                inventory.setField(id, value);
            }

            public int getFieldCount() {
                return inventory.getFieldCount();
            }

            public void clear() {
                inventory.clear();
            }

            public boolean isEmpty() {
                return inventory.isEmpty();
            }
        };
    }

    public static ISidedInventory getSidedInventoryCopy(final ISidedInventory inventory) {
        return new ISidedInventory(){

            public String getName() {
                return inventory.getName();
            }

            public boolean hasCustomName() {
                return inventory.hasCustomName();
            }

            public ITextComponent getDisplayName() {
                return inventory.getDisplayName();
            }

            public int getSizeInventory() {
                return inventory.getSizeInventory();
            }

            public ItemStack getStackInSlot(int index) {
                return inventory.getStackInSlot(index);
            }

            public ItemStack decrStackSize(int index, int count) {
                return inventory.decrStackSize(index, count);
            }

            public ItemStack removeStackFromSlot(int index) {
                return inventory.removeStackFromSlot(index);
            }

            public void setInventorySlotContents(int index, ItemStack stack) {
                inventory.setInventorySlotContents(index, stack);
            }

            public int getInventoryStackLimit() {
                return inventory.getInventoryStackLimit();
            }

            public void markDirty() {
                inventory.markDirty();
            }

            public boolean isUsableByPlayer(EntityPlayer player) {
                return inventory.isUsableByPlayer(player);
            }

            public void openInventory(EntityPlayer player) {
                inventory.openInventory(player);
            }

            public void closeInventory(EntityPlayer player) {
                inventory.closeInventory(player);
            }

            public boolean isItemValidForSlot(int index, ItemStack stack) {
                return inventory.isItemValidForSlot(index, stack);
            }

            public int getField(int id) {
                return inventory.getField(id);
            }

            public void setField(int id, int value) {
                inventory.setField(id, value);
            }

            public int getFieldCount() {
                return inventory.getFieldCount();
            }

            public void clear() {
                inventory.clear();
            }

            public int[] getSlotsForFace(EnumFacing side) {
                return inventory.getSlotsForFace(side);
            }

            public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
                return inventory.canInsertItem(index, itemStackIn, direction);
            }

            public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
                return inventory.canExtractItem(index, stack, direction);
            }

            public boolean isEmpty() {
                return inventory.isEmpty();
            }
        };
    }

    public static ItemStack insertMergeable(IInventory inventory, int slot, ItemStack stack, ItemStack existingStack) {
        int stackLimit = Math.min(inventory.getInventoryStackLimit(), stack.getMaxStackSize());
        if (existingStack.getCount() >= stackLimit) {
            return stack;
        }
        if (stack.getCount() + existingStack.getCount() > stackLimit) {
            int stackDiff = stackLimit - existingStack.getCount();
            existingStack.setCount(stackLimit);
            stack.shrink(stackDiff);
            inventory.setInventorySlotContents(slot, existingStack);
            return stack;
        }
        existingStack.grow(stack.getCount());
        inventory.setInventorySlotContents(slot, existingStack);
        return stackLimit >= stack.getCount() ? ItemStack.EMPTY : stack.splitStack(stack.getCount() - stackLimit);
    }

    public static ItemStack insertEmpty(IInventory inventory, int slot, ItemStack stack) {
        if (!inventory.isItemValidForSlot(slot, stack)) {
            return stack;
        }
        int stackLimit = inventory.getInventoryStackLimit();
        inventory.setInventorySlotContents(slot, stack.copy());
        return stackLimit >= stack.getCount() ? ItemStack.EMPTY : stack.splitStack(stack.getCount() - stackLimit);
    }

    public static ItemStack insertStack(TileEntity tile, ItemStack stack) {
        EnumFacing facing;
        ItemStack returnStack = stack;
        if (!ItemStack.areItemStacksEqual((ItemStack)returnStack, (ItemStack)(stack = InventoryUtils.insertStack(tile, null, stack.copy())))) {
            return stack;
        }
        EnumFacing[] enumFacingArray = EnumFacing.VALUES;
        int n = enumFacingArray.length;
        for (int i = 0; i < n && ItemStack.areItemStacksEqual((ItemStack)stack, (ItemStack)(returnStack = InventoryUtils.insertStack(tile, facing = enumFacingArray[i], stack.copy()))); ++i) {
        }
        return returnStack;
    }

    public static ItemStack insertStack(TileEntity tile, EnumFacing side, ItemStack stack) {
        return InventoryUtils.insertStack(tile, side, stack, false);
    }

    public static ItemStack insertStack(TileEntity tile, EnumFacing side, ItemStack stack, boolean simulate) {
        ItemStack newStack = stack;
        if (!stack.isEmpty()) {
            if (InventoryUtils.isItemHandler(tile, side)) {
                IItemHandler handler = InventoryUtils.getItemHandler(tile, side);
                if (handler != null) {
                    newStack = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack.copy(), (boolean)simulate);
                }
            } else if (InventoryUtils.isInventory(tile)) {
                newStack = tile instanceof ISidedInventory ? InventoryUtils.insertItem((IInventory)((ISidedInventory)tile), stack.copy(), side) : InventoryUtils.insertItem((IInventory)tile, stack.copy());
            }
        }
        return newStack;
    }

    public static boolean invHasRoomForStack(IItemHandler inv, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stackInSlot = inv.getStackInSlot(slot);
            if (!stackInSlot.isEmpty()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) continue;
                int m = Math.min(stack.getMaxStackSize(), inv.getStackInSlot(slot).getMaxStackSize()) - stackInSlot.getCount();
                if (stack.getCount() >= m) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static ItemStack insertItem(IInventory inv, ItemStack stack, boolean simulate) {
        if (stack.isEmpty() || inv.getSizeInventory() <= 0) {
            return ItemStack.EMPTY;
        }
        for (int slot = 0; slot < inv.getSizeInventory(); ++slot) {
            int m;
            if (!inv.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            ItemStack stackInSlot = inv.getStackInSlot(slot);
            if (!stackInSlot.isEmpty()) {
                ItemStack copy;
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                    return stack;
                }
                m = Math.min(stack.getMaxStackSize(), inv.getInventoryStackLimit()) - stackInSlot.getCount();
                if (stack.getCount() <= m) {
                    if (simulate) continue;
                    copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    inv.setInventorySlotContents(slot, copy);
                    inv.markDirty();
                    continue;
                }
                stack = stack.copy();
                if (!simulate) {
                    copy = stack.splitStack(m);
                    copy.grow(stackInSlot.getCount());
                    inv.setInventorySlotContents(slot, copy);
                    inv.markDirty();
                    return stack;
                }
                stack.shrink(m);
                return stack;
            }
            m = Math.min(stack.getMaxStackSize(), inv.getInventoryStackLimit());
            if (m < stack.getCount()) {
                stack = stack.copy();
                if (!simulate) {
                    inv.setInventorySlotContents(slot, stack.splitStack(m));
                    inv.markDirty();
                    return stack;
                }
                stack.shrink(m);
                return stack;
            }
            if (!simulate) {
                inv.setInventorySlotContents(slot, stack);
                inv.markDirty();
            }
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @Nullable
    public static ItemStack addItem(IInventory inv, ItemStack stack) {
        ItemStack itemstack = stack.copy();
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack itemstack1 = inv.getStackInSlot(i);
            if (itemstack1.isEmpty()) {
                inv.setInventorySlotContents(i, itemstack);
                inv.markDirty();
                return ItemStack.EMPTY;
            }
            if (!ItemStack.areItemsEqual((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            int j = Math.min(inv.getInventoryStackLimit(), itemstack1.getMaxStackSize());
            int k = Math.min(itemstack.getCount(), j - itemstack1.getCount());
            if (k <= 0) continue;
            itemstack1.grow(k);
            itemstack.shrink(k);
            if (itemstack.getCount() > 0) continue;
            inv.markDirty();
            return ItemStack.EMPTY;
        }
        if (itemstack.getCount() != stack.getCount()) {
            inv.markDirty();
        }
        return itemstack;
    }
}

