/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemNBTUtils {
    public static boolean hasTag(@Nonnull ItemStack stack) {
        return stack.hasTagCompound();
    }

    public static void setTag(@Nonnull ItemStack stack, NBTTagCompound tagCompound) {
        stack.setTagCompound(tagCompound);
    }

    public static NBTTagCompound getTag(@Nonnull ItemStack stack) {
        return stack.getTagCompound();
    }

    public static NBTTagCompound validateTagExists(@Nonnull ItemStack stack) {
        if (!ItemNBTUtils.hasTag(stack)) {
            ItemNBTUtils.setTag(stack, new NBTTagCompound());
        }
        return ItemNBTUtils.getTag(stack);
    }

    public static boolean hasKey(@Nonnull ItemStack stack, String key) {
        return ItemNBTUtils.hasTag(stack) && ItemNBTUtils.getTag(stack).hasKey(key);
    }

    public static boolean hasKey(@Nonnull ItemStack stack, String key, int nbtType) {
        return ItemNBTUtils.hasTag(stack) && ItemNBTUtils.getTag(stack).hasKey(key, nbtType);
    }

    public static void removeTag(@Nonnull ItemStack stack, String key) {
        if (ItemNBTUtils.hasTag(stack)) {
            ItemNBTUtils.getTag(stack).removeTag(key);
        }
    }

    public static void setByte(@Nonnull ItemStack stack, String key, byte b) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).setByte(key, b);
    }

    public static void setShort(@Nonnull ItemStack stack, String key, short s) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).setShort(key, s);
    }

    public static void setInteger(@Nonnull ItemStack stack, String key, int i) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).setInteger(key, i);
    }

    public static void setLong(@Nonnull ItemStack stack, String key, long l) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).setLong(key, l);
    }

    public static void setUUID(@Nonnull ItemStack stack, String key, UUID uuid) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).setUniqueId(key, uuid);
    }

    public static void setFloat(@Nonnull ItemStack stack, String key, float f) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).setFloat(key, f);
    }

    public static void setDouble(@Nonnull ItemStack stack, String key, double d) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).setDouble(key, d);
    }

    public static void setString(@Nonnull ItemStack stack, String key, String s) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).setString(key, s);
    }

    public static void setByteArray(@Nonnull ItemStack stack, String key, byte[] b) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).setByteArray(key, b);
    }

    public static void setIntArray(@Nonnull ItemStack stack, String key, int[] i) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).setIntArray(key, i);
    }

    public static void setBoolean(@Nonnull ItemStack stack, String key, boolean b) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).setBoolean(key, b);
    }

    public static byte getByte(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getByte(key);
    }

    public static short getShort(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getShort(key);
    }

    public static int getInteger(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getInteger(key);
    }

    public static long getLong(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getLong(key);
    }

    public static UUID getUUID(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getUniqueId(key);
    }

    public static float getFloat(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getFloat(key);
    }

    public static double getDouble(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getDouble(key);
    }

    public static String getString(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getString(key);
    }

    public static byte[] getByteArray(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getByteArray(key);
    }

    public static int[] getIntArray(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getIntArray(key);
    }

    public static boolean getBoolean(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getBoolean(key);
    }

    public static NBTTagCompound getCompoundTag(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getCompoundTag(key);
    }

    public static NBTTagList getTagList(@Nonnull ItemStack stack, String key, int type) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).getTagList(key, type);
    }

    public static boolean hasNBTTagList(@Nonnull ItemStack stack, String key) {
        return ItemNBTUtils.hasTag(stack) ? ItemNBTUtils.hasKey(stack, key, 9) : false;
    }

    public static NBTTagList getNBTTagList(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTagList(stack, key, 10);
    }

    public static boolean hasInt(@Nonnull ItemStack stack, String key) {
        return ItemNBTUtils.hasKey(stack, key, 3);
    }

    public static int getInt(@Nonnull ItemStack stack, String key) {
        return ItemNBTUtils.getInteger(stack, key);
    }

    public static NBTTagCompound getRawStack(ItemStack stack) {
        return stack.serializeNBT();
    }
}

