/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import p455w0rdslib.util.EasyMappings;

public class ItemUtils {
    public static ItemStack getHelmet(EntityPlayer player) {
        return player.inventory.getStackInSlot(39);
    }

    public static ItemStack getChestplate(EntityPlayer player) {
        return player.inventory.getStackInSlot(38);
    }

    public static ItemStack getLeggings(EntityPlayer player) {
        return player.inventory.getStackInSlot(37);
    }

    public static ItemStack getBoots(EntityPlayer player) {
        return player.inventory.getStackInSlot(36);
    }

    public static boolean areItemStacksEqualIgnoreSize(ItemStack stack1, ItemStack stack2) {
        return stack1.isItemEqual(stack2) && ItemStack.areItemStackTagsEqual((ItemStack)stack1, (ItemStack)stack2);
    }

    public static void dropItemStackInWorld(World worldObj, double x, double y, double z, ItemStack stack) {
        float f = 0.7f;
        float d0 = worldObj.rand.nextFloat() * 0.7f + 0.15f;
        float d1 = worldObj.rand.nextFloat() * 0.7f + 0.15f;
        float d2 = worldObj.rand.nextFloat() * 0.7f + 0.15f;
        EntityItem entityitem = new EntityItem(worldObj, x + (double)d0, y + (double)d1, z + (double)d2, stack);
        entityitem.setPickupDelay(10);
        if (stack.hasTagCompound()) {
            entityitem.getItem().setTagCompound(stack.getTagCompound().copy());
        }
        EasyMappings.spawn(worldObj, (Entity)entityitem);
    }

    public static boolean readBoolean(ItemStack is, String key) {
        if (is == null) {
            return false;
        }
        NBTTagCompound tag = ItemUtils.getTag(is);
        return tag.hasKey(key) ? tag.getBoolean(key) : false;
    }

    public static int readInt(ItemStack is, String key) {
        if (is == null) {
            return 0;
        }
        NBTTagCompound tag = ItemUtils.getTag(is);
        return tag.hasKey(key) ? tag.getInteger(key) : -1;
    }

    public static void writeInt(ItemStack is, String key, int value) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = ItemUtils.getTag(is);
        tag.setInteger(key, value);
    }

    public static void writeBoolean(ItemStack is, String key, boolean value) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = ItemUtils.getTag(is);
        tag.setBoolean(key, value);
    }

    public static void delKey(ItemStack is, String key) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = ItemUtils.getTag(is);
        tag.removeTag(key);
    }

    public static NBTTagCompound getTag(ItemStack is) {
        if (!is.hasTagCompound()) {
            is.setTagCompound(new NBTTagCompound());
        }
        return is.getTagCompound();
    }

    public static ItemStack readStack(NBTTagCompound nbtTC, String key) {
        return nbtTC.hasKey(key) ? new ItemStack(nbtTC) : null;
    }

    public static boolean areStacksSameSize(ItemStack stackA, ItemStack stackB) {
        return stackA == null && stackB == null || stackA != null && stackB != null && stackA.getCount() == stackB.getCount();
    }
}

