/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class MappingsUtil {
    private static Map<String, String> methods_mcp2srg = new HashMap<String, String>();
    private static Map<String, String> methods_srg2mcp = new HashMap<String, String>();
    private static Map<String, String> fields_mcp2srg = new HashMap<String, String>();
    private static Map<String, String> fields_srg2mcp = new HashMap<String, String>();
    private static List<String> mcpMethods = new ArrayList<String>();
    private static List<String> srgMethods = new ArrayList<String>();
    private static List<String> mcpFields = new ArrayList<String>();
    private static List<String> srgFields = new ArrayList<String>();

    private static final String getMappingsDir() {
        try {
            Class<?> gradleClass = Class.forName("net.minecraftforge.gradle.GradleStartCommon");
            Field dirField = gradleClass.getDeclaredField("CSV_DIR");
            dirField.setAccessible(true);
            File mappingDir = (File)dirField.get(null);
            return mappingDir.getAbsolutePath() + "/";
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("[p455w0rdc0re] [ERROR] Error getting mappings from Gradlew SRG, falling back to mcp folder.");
            return "./../mcp/";
        }
    }

    public static final boolean mcp() {
        return false;
    }

    public static final String getField(String name) {
        if (MappingsUtil.mcp()) {
            if (MappingsUtil.isSRG(name)) {
                return fields_srg2mcp.get(name);
            }
        } else if (MappingsUtil.isMCP(name)) {
            return fields_mcp2srg.get(name);
        }
        return name;
    }

    public static final String getMethod(String name) {
        if (MappingsUtil.mcp()) {
            if (MappingsUtil.isSRG(name)) {
                return methods_srg2mcp.get(name);
            }
        } else if (MappingsUtil.isMCP(name)) {
            return methods_mcp2srg.get(name);
        }
        return name;
    }

    private static boolean isSRG(String str) {
        return srgMethods.contains(str) || srgFields.contains(str);
    }

    private static boolean isMCP(String str) {
        return mcpMethods.contains(str) || mcpFields.contains(str);
    }

    private static void readMethodMappings() {
        Map<String, String> map = MappingsUtil.readMappings(new File(MappingsUtil.getMappingsDir() + "methods.csv"));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            srgMethods.add(entry.getKey());
            mcpMethods.add(entry.getValue());
            methods_srg2mcp.put(entry.getKey(), entry.getValue());
            methods_mcp2srg.put(entry.getValue(), entry.getKey());
        }
    }

    private static void readFieldMappings() {
        Map<String, String> map = MappingsUtil.readMappings(new File(MappingsUtil.getMappingsDir() + "fields.csv"));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            srgFields.add(entry.getKey());
            mcpFields.add(entry.getValue());
            fields_srg2mcp.put(entry.getKey(), entry.getValue());
            fields_mcp2srg.put(entry.getValue(), entry.getKey());
        }
    }

    private static final Map<String, String> readMappings(File file) {
        if (!file.isFile()) {
            throw new RuntimeException("Couldn't find MCP mappings.");
        }
        try {
            return (Map)Files.readLines((File)file, (Charset)Charsets.UTF_8, (LineProcessor)new MCPFileParser());
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read SRG->MCP mappings", e);
        }
    }

    static {
        if (MappingsUtil.mcp()) {
            MappingsUtil.readMethodMappings();
            MappingsUtil.readFieldMappings();
        }
    }

    private static class MCPFileParser
    implements LineProcessor<Map<String, String>> {
        private static final Splitter splitter = Splitter.on((char)',').trimResults();
        private final Map<String, String> map = Maps.newHashMap();
        private boolean foundFirst;

        private MCPFileParser() {
        }

        public boolean processLine(String line) throws IOException {
            if (!this.foundFirst) {
                this.foundFirst = true;
                return true;
            }
            Iterator splitted = splitter.split((CharSequence)line).iterator();
            try {
                String srg = (String)splitted.next();
                String mcp = (String)splitted.next();
                if (!this.map.containsKey(srg)) {
                    this.map.put(srg, mcp);
                }
            }
            catch (NoSuchElementException e) {
                throw new IOException("Invalid Mappings file!", e);
            }
            return true;
        }

        public Map<String, String> getResult() {
            return ImmutableMap.copyOf(this.map);
        }
    }
}

