/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.util.ResourceLocation;

public class PlayerTextureUtils {
    private static NetworkPlayerInfo getPlayerInfo(AbstractClientPlayer player) {
        return Minecraft.getMinecraft().getConnection().getPlayerInfo(player.getUniqueID());
    }

    private static Map<MinecraftProfileTexture.Type, ResourceLocation> getPlayerTextures(AbstractClientPlayer player) {
        return PlayerTextureUtils.getPlayerInfo((AbstractClientPlayer)player).playerTextures;
    }

    public static ResourceLocation getCape(AbstractClientPlayer player) {
        return PlayerTextureUtils.getPlayerTextures(player).get(MinecraftProfileTexture.Type.CAPE);
    }

    public static ResourceLocation getElytra(AbstractClientPlayer player) {
        return PlayerTextureUtils.getPlayerTextures(player).get(MinecraftProfileTexture.Type.ELYTRA);
    }

    public static ResourceLocation getSkin(AbstractClientPlayer player) {
        return PlayerTextureUtils.getPlayerTextures(player).get(MinecraftProfileTexture.Type.SKIN);
    }

    public static void setCape(AbstractClientPlayer player, ResourceLocation texture) {
        PlayerTextureUtils.getPlayerTextures(player).put(MinecraftProfileTexture.Type.CAPE, texture);
    }

    public static void setElytra(AbstractClientPlayer player, ResourceLocation texture) {
        PlayerTextureUtils.getPlayerTextures(player).put(MinecraftProfileTexture.Type.ELYTRA, texture);
    }

    public static void setSkin(AbstractClientPlayer player, ResourceLocation texture) {
        PlayerTextureUtils.getPlayerTextures(player).put(MinecraftProfileTexture.Type.SKIN, texture);
    }

    public static boolean hasCape(AbstractClientPlayer player) {
        return PlayerTextureUtils.getCape(player) != null;
    }

    public static boolean hasElytra(AbstractClientPlayer player) {
        return PlayerTextureUtils.getElytra(player) != null;
    }

    public static boolean hasSkin(AbstractClientPlayer player) {
        return PlayerTextureUtils.getSkin(player) != null;
    }
}

