/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.StringUtils;
import p455w0rdslib.LibRegistry;
import p455w0rdslib.P455w0rdsLib;
import p455w0rdslib.util.EasyMappings;
import p455w0rdslib.util.MathUtils;
import p455w0rdslib.util.ProxiedUtils;

public class PlayerUtils {
    public static EntityPlayer getPlayer() {
        return EasyMappings.player();
    }

    public static EntityPlayer getPlayerByContext(MessageContext ctx) {
        return P455w0rdsLib.PROXY.getPlayer(ctx);
    }

    public static void writeProfileToNBT(GameProfile profile, NBTTagCompound tag) {
        tag.setString("Name", profile.getName());
        UUID id = profile.getId();
        if (id != null) {
            tag.setLong("UUIDL", id.getLeastSignificantBits());
            tag.setLong("UUIDU", id.getMostSignificantBits());
        }
    }

    public static GameProfile profileFromNBT(NBTTagCompound tag) {
        String name = tag.getString("Name");
        UUID uuid = null;
        if (tag.hasKey("UUIDL")) {
            uuid = new UUID(tag.getLong("UUIDU"), tag.getLong("UUIDL"));
        } else if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return new GameProfile(uuid, name);
    }

    public static NBTTagCompound proifleToNBT(GameProfile profile) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("Name", profile.getName());
        UUID id = profile.getId();
        if (id != null) {
            tag.setLong("UUIDL", id.getLeastSignificantBits());
            tag.setLong("UUIDU", id.getMostSignificantBits());
        }
        return tag;
    }

    public static EntityPlayer getPlayerFromWorld(World world, UUID player) {
        if (player == null) {
            return null;
        }
        List players = world.playerEntities;
        for (EntityPlayer entityPlayer : players) {
            if (entityPlayer.getUniqueID().compareTo(player) != 0) continue;
            return entityPlayer;
        }
        return null;
    }

    public static UUID getPlayerID(GameProfile profile) {
        return profile.getId();
    }

    public static GameProfile getPlayerProfile(GameProfile profile) {
        return profile;
    }

    public static boolean isOp(ICommandSender sender) {
        EntityPlayer player;
        if (!ProxiedUtils.isSMP()) {
            return true;
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            if (sender instanceof EntityPlayer) {
                EntityPlayer player2 = (EntityPlayer)sender;
                return player2.capabilities.isCreativeMode || player2.isSpectator();
            }
        } else if (FMLCommonHandler.instance().getSide() == Side.SERVER && sender instanceof EntityPlayerMP && (player = sender.getEntityWorld().getPlayerEntityByName(sender.getName())) != null && player.getGameProfile() != null) {
            UserListOpsEntry userentry = (UserListOpsEntry)((EntityPlayerMP)player).mcServer.getPlayerList().getOppedPlayers().getEntry((Object)player.getGameProfile());
            return userentry != null && userentry.getPermissionLevel() >= 4;
        }
        if (sender instanceof TileEntityCommandBlock) {
            return true;
        }
        return sender.getName().equalsIgnoreCase("@") || sender.getName().equals("Server");
    }

    public static List<UUID> getFullPlayerList() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        ArrayList uuidList = Lists.newArrayList();
        if (server != null) {
            String[] usernames;
            PlayerProfileCache playerCache = server.getPlayerProfileCache();
            for (String username : usernames = EasyMappings.getNames(server)) {
                uuidList.add(playerCache.getGameProfileForUsername(username).getId());
            }
        }
        return uuidList;
    }

    public static ItemStack getPlayerSkull(String playerName) {
        ItemStack head = null;
        Map<String, ItemStack> skullCache = LibRegistry.getSkullRegistry();
        if (!skullCache.containsKey(playerName)) {
            head = new ItemStack(Items.SKULL, 1, 3);
            NBTTagCompound nametag = new NBTTagCompound();
            nametag.setString("SkullOwner", playerName);
            head.setTagCompound(nametag);
            skullCache.put(playerName, head);
        }
        return skullCache.get(playerName);
    }

    public static double getDistanceToPos(double x, double y, double z) {
        EntityPlayerSP p = Minecraft.getMinecraft().player;
        return MathUtils.getDistanceSq(x, y, z, p.posX, p.posY, p.posZ);
    }
}

