/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import p455w0rdslib.util.EasyMappings;
import p455w0rdslib.util.EntityUtils;

public class TeleportUtils {
    public static Entity teleportEntity(Entity entity, int dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity == null || EasyMappings.world((Entity)entity).isRemote) {
            return entity;
        }
        MinecraftServer server = entity.getServer();
        int sourceDim = EasyMappings.world((Entity)entity).provider.getDimension();
        if (!entity.isBeingRidden() && !entity.isRiding()) {
            return TeleportUtils.handleEntityTeleport(entity, server, sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        }
        Entity rootEntity = entity.getLowestRidingEntity();
        PassengerHelper passengerHelper = new PassengerHelper(rootEntity);
        PassengerHelper rider = passengerHelper.getPassenger(entity);
        if (rider == null) {
            return entity;
        }
        passengerHelper.teleport(server, sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        passengerHelper.remountRiders();
        passengerHelper.updateClients();
        return rider.entity;
    }

    public static Entity teleportEntity(Entity entity, int dimension, double xCoord, double yCoord, double zCoord) {
        return TeleportUtils.teleportEntity(entity, dimension, xCoord, yCoord, zCoord, entity.rotationYaw, entity.rotationPitch);
    }

    private static Entity handleEntityTeleport(Entity entity, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        boolean interDimensional;
        if (entity == null || EasyMappings.world((Entity)entity).isRemote) {
            return entity;
        }
        boolean bl = interDimensional = sourceDim != targetDim;
        if (interDimensional && !ForgeHooks.onTravelToDimension((Entity)entity, (int)targetDim)) {
            return entity;
        }
        if (interDimensional) {
            if (entity instanceof EntityPlayerMP) {
                return TeleportUtils.teleportPlayerInternational((EntityPlayerMP)entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
            return TeleportUtils.teleportEntityInternational(entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.connection.setPlayerLocation(xCoord, yCoord, zCoord, yaw, pitch);
            player.setRotationYawHead(yaw);
        } else {
            entity.setLocationAndAngles(xCoord, yCoord, zCoord, yaw, pitch);
            entity.setRotationYawHead(yaw);
        }
        return entity;
    }

    private static Entity teleportEntityInternational(Entity entity, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity.isDead) {
            return null;
        }
        WorldServer sourceWorld = server.getWorld(sourceDim);
        WorldServer targetWorld = server.getWorld(targetDim);
        entity.dimension = targetDim;
        sourceWorld.removeEntity(entity);
        entity.isDead = false;
        entity.setLocationAndAngles(xCoord, yCoord, zCoord, yaw, pitch);
        sourceWorld.updateEntityWithOptionalForce(entity, false);
        Entity newEntity = EntityList.createEntityByIDFromName((ResourceLocation)new ResourceLocation(EntityList.getEntityString((Entity)entity)), (World)targetWorld);
        if (newEntity != null) {
            EntityUtils.copyDataFromOld(entity, newEntity);
            newEntity.setLocationAndAngles(xCoord, yCoord, zCoord, yaw, pitch);
            boolean flag = newEntity.forceSpawn;
            newEntity.forceSpawn = true;
            EasyMappings.spawn((World)targetWorld, newEntity);
            newEntity.forceSpawn = flag;
            targetWorld.updateEntityWithOptionalForce(newEntity, false);
        }
        entity.isDead = true;
        sourceWorld.resetUpdateEntityTick();
        targetWorld.resetUpdateEntityTick();
        return newEntity;
    }

    private static EntityPlayer teleportPlayerInternational(EntityPlayerMP player, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        WorldServer sourceWorld = server.getWorld(sourceDim);
        WorldServer targetWorld = server.getWorld(targetDim);
        PlayerList playerList = server.getPlayerList();
        player.dimension = targetDim;
        player.connection.sendPacket((Packet)new SPacketRespawn(player.dimension, targetWorld.getDifficulty(), targetWorld.getWorldInfo().getTerrainType(), player.interactionManager.getGameType()));
        playerList.updatePermissionLevel(player);
        sourceWorld.removeEntityDangerously((Entity)player);
        player.isDead = false;
        player.setLocationAndAngles(xCoord, yCoord, zCoord, yaw, pitch);
        player.connection.setPlayerLocation(xCoord, yCoord, zCoord, yaw, pitch);
        EasyMappings.spawn((World)targetWorld, (Entity)player);
        targetWorld.updateEntityWithOptionalForce((Entity)player, false);
        player.setWorld((World)targetWorld);
        playerList.preparePlayer(player, sourceWorld);
        player.connection.setPlayerLocation(xCoord, yCoord, zCoord, yaw, pitch);
        player.interactionManager.setWorld(targetWorld);
        player.connection.sendPacket((Packet)new SPacketPlayerAbilities(player.capabilities));
        playerList.updateTimeAndWeatherForPlayer(player, targetWorld);
        playerList.syncPlayerInventory(player);
        for (PotionEffect potioneffect : player.getActivePotionEffects()) {
            player.connection.sendPacket((Packet)new SPacketEntityEffect(player.getEntityId(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, sourceDim, targetDim);
        player.setLocationAndAngles(xCoord, yCoord, zCoord, yaw, pitch);
        return player;
    }

    public static Entity getHighestRidingEntity(Entity mount) {
        Entity entity = mount;
        while (entity.getPassengers().size() > 0) {
            entity = (Entity)entity.getPassengers().get(0);
        }
        return entity;
    }

    private static class PassengerHelper {
        public Entity entity;
        public LinkedList<PassengerHelper> passengers = new LinkedList();
        public double offsetX;
        public double offsetY;
        public double offsetZ;

        public PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.isRiding()) {
                this.offsetX = entity.posX - entity.getRidingEntity().posX;
                this.offsetY = entity.posY - entity.getRidingEntity().posY;
                this.offsetZ = entity.posZ - entity.getRidingEntity().posZ;
            }
            for (Entity passenger : entity.getPassengers()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        public void teleport(MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
            this.entity.removePassengers();
            this.entity = TeleportUtils.handleEntityTeleport(this.entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
        }

        public void remountRiders() {
            if (this.entity.isRiding()) {
                this.entity.setLocationAndAngles(this.entity.posX + this.offsetX, this.entity.posY + this.offsetY, this.entity.posZ + this.offsetZ, this.entity.rotationYaw, this.entity.rotationPitch);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.entity.startRiding(this.entity, true);
                passenger.remountRiders();
            }
        }

        public void updateClients() {
            if (this.entity instanceof EntityPlayerMP) {
                this.updateClient((EntityPlayerMP)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(EntityPlayerMP playerMP) {
            if (this.entity.isBeingRidden()) {
                playerMP.connection.sendPacket((Packet)new SPacketSetPassengers(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        public PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

