/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import cofh.redstoneflux.api.IEnergyHandler;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import p455w0rdslib.util.FluidUtils;
import p455w0rdslib.util.InventoryUtils;

public class TileEntityUtils {
    public static void markBlockForUpdate(World world, BlockPos pos) {
        if (world != null) {
            world.notifyBlockUpdate(pos, world.getBlockState(pos), world.getBlockState(pos), 3);
        }
    }

    public static TileEntity getAdjacentTile(World world, BlockPos pos, EnumFacing dir) {
        pos = pos.offset(dir);
        return world == null || !world.isBlockLoaded(pos) ? null : world.getTileEntity(pos);
    }

    public static TileEntity getAdjacentTile(World world, BlockPos pos, int side) {
        return world == null ? null : TileEntityUtils.getAdjacentTile(world, pos, EnumFacing.VALUES[side]);
    }

    public static TileEntity getAdjacentTile(TileEntity te, EnumFacing dir) {
        return te == null ? null : TileEntityUtils.getAdjacentTile(te.getWorld(), te.getPos(), dir);
    }

    public static TileEntity getAdjacentTile(TileEntity te, int side) {
        return te == null ? null : TileEntityUtils.getAdjacentTile(te.getWorld(), te.getPos(), EnumFacing.VALUES[side]);
    }

    public static List<TileEntity> getAdjacentTiles(TileEntity te) {
        return TileEntityUtils.getAdjacentTiles(te, false);
    }

    public static List<TileEntity> getAdjacentHorizontalTiles(TileEntity te) {
        return TileEntityUtils.getAdjacentTiles(te, true);
    }

    private static List<TileEntity> getAdjacentTiles(TileEntity te, boolean horizontal) {
        ArrayList tileList = Lists.newArrayList();
        for (EnumFacing facing : horizontal ? EnumFacing.HORIZONTALS : EnumFacing.VALUES) {
            tileList.add(TileEntityUtils.getAdjacentTile(te, facing));
        }
        return tileList;
    }

    public static List<IEnergyHandler> getAdjacentRFTiles(TileEntity te) {
        return TileEntityUtils.getAdjacentRFTiles(te, false);
    }

    public static List<IEnergyHandler> getAdjacentHorizontalRFTiles(TileEntity te) {
        return TileEntityUtils.getAdjacentRFTiles(te, false);
    }

    private static List<IEnergyHandler> getAdjacentRFTiles(TileEntity te, boolean horizontal) {
        ArrayList tileList = Lists.newArrayList();
        for (TileEntity tile : horizontal ? TileEntityUtils.getAdjacentTiles(te, true) : TileEntityUtils.getAdjacentTiles(te)) {
            if (tile == null || !(tile instanceof IEnergyHandler)) continue;
            tileList.add((IEnergyHandler)tile);
        }
        return tileList;
    }

    public static List<IEnergyReceiver> getAdjacentRFReceivers(TileEntity te, boolean horizontal) {
        ArrayList tileList = Lists.newArrayList();
        for (IEnergyHandler tile : TileEntityUtils.getAdjacentRFTiles(te, horizontal)) {
            if (!(tile instanceof IEnergyReceiver)) continue;
            tileList.add((IEnergyReceiver)tile);
        }
        return tileList;
    }

    public static List<IEnergyProvider> getAdjacentRFProviders(TileEntity te, boolean horizontal) {
        ArrayList tileList = Lists.newArrayList();
        for (IEnergyHandler tile : TileEntityUtils.getAdjacentRFTiles(te, horizontal)) {
            if (!(tile instanceof IEnergyProvider)) continue;
            tileList.add((IEnergyProvider)tile);
        }
        return tileList;
    }

    public static List<TileEntity> getAdjacentItemTiles(TileEntity te) {
        return TileEntityUtils.getAdjacentItemTiles(te, false);
    }

    public static List<TileEntity> getAdjacentHorizontalItemTiles(TileEntity te) {
        return TileEntityUtils.getAdjacentItemTiles(te, true);
    }

    private static List<TileEntity> getAdjacentItemTiles(TileEntity te, boolean horizontal) {
        ArrayList tileList = Lists.newArrayList();
        for (TileEntity tile : horizontal ? TileEntityUtils.getAdjacentTiles(te, true) : TileEntityUtils.getAdjacentTiles(te)) {
            if (tile == null) continue;
            if (InventoryUtils.isItemHandler(tile, null) && InventoryUtils.getItemHandler(tile, null) != null && !tileList.contains(tile)) {
                tileList.add(tile);
            }
            for (EnumFacing element : EnumFacing.VALUES) {
                if (!InventoryUtils.isItemHandler(tile, element) || InventoryUtils.getItemHandler(tile, element) == null || tileList.contains(tile)) continue;
                tileList.add(tile);
            }
        }
        return tileList;
    }

    public static List<TileEntity> getAdjacentFluidTiles(TileEntity te) {
        return TileEntityUtils.getAdjacentFluidTiles(te, false);
    }

    public static List<TileEntity> getAdjacentHorizontalFluidTiles(TileEntity te) {
        return TileEntityUtils.getAdjacentFluidTiles(te, true);
    }

    private static List<TileEntity> getAdjacentFluidTiles(TileEntity te, boolean horizontal) {
        ArrayList tileList = Lists.newArrayList();
        for (EnumFacing facing : horizontal ? EnumFacing.HORIZONTALS : EnumFacing.VALUES) {
            if (te == null || te.getWorld() == null || te.getPos() == null) break;
            BlockPos pos = te.getPos();
            TileEntity currentTile = te.getWorld().getTileEntity(pos.offset(facing));
            if (currentTile == null || tileList.contains(currentTile) || FluidUtils.getFluidHandler(currentTile, facing) == null) continue;
            tileList.add(currentTile);
        }
        return tileList;
    }

    public static List<TileEntity> getAdjacentFluidTilesWidthSpace(TileEntity te, FluidStack fluid) {
        ArrayList tileList = Lists.newArrayList();
        for (TileEntity tile : TileEntityUtils.getAdjacentFluidTiles(te)) {
            for (EnumFacing facing : EnumFacing.values()) {
                if (tile == null || !FluidUtils.hasRoomForFluid(te, fluid, facing) || tileList.contains(tile)) continue;
                tileList.add(tile);
            }
        }
        return tileList;
    }

    public static List<TileEntity> getAdjacentInventoryTiles(TileEntity te) {
        return TileEntityUtils.getAdjacentInventoryTiles(te, false);
    }

    public static List<TileEntity> getAdjacentHorizontalInventoryTiles(TileEntity te) {
        return TileEntityUtils.getAdjacentInventoryTiles(te, true);
    }

    private static List<TileEntity> getAdjacentInventoryTiles(TileEntity te, boolean horizontal) {
        ArrayList tileList = Lists.newArrayList();
        for (TileEntity tile : TileEntityUtils.getAdjacentTiles(te, horizontal)) {
            if (!InventoryUtils.isInventory(tile)) continue;
            if (tile instanceof ISidedInventory) {
                for (int i = 0; i < EnumFacing.values().length; ++i) {
                    if (((ISidedInventory)tile).getSlotsForFace(EnumFacing.values()[i]).length <= 0 || tileList.contains(tile)) continue;
                    tileList.add(tile);
                }
                continue;
            }
            if (tileList.contains(tile)) continue;
            tileList.add(tile);
        }
        return tileList;
    }

    public static List<TileEntity> getAdjacentItemStorageTiles(TileEntity te) {
        ArrayList tileList = Lists.newArrayList();
        for (TileEntity tile : TileEntityUtils.getAdjacentInventoryTiles(te)) {
            if (tileList.contains(tile)) continue;
            tileList.add(tile);
        }
        for (TileEntity tile : TileEntityUtils.getAdjacentItemTiles(te)) {
            if (tileList.contains(tile)) continue;
            tileList.add(tile);
        }
        return tileList;
    }

    public static boolean hasAdjacentItemStorageTile(TileEntity te) {
        return !TileEntityUtils.getAdjacentInventoryTiles(te).isEmpty() || !TileEntityUtils.getAdjacentItemTiles(te).isEmpty();
    }

    public static boolean hasAdjacentItemStorageTileWithSpace(TileEntity te, ItemStack stack) {
        if (TileEntityUtils.hasAdjacentItemStorageTile(te)) {
            for (TileEntity tile : TileEntityUtils.getAdjacentItemStorageTiles(te)) {
                if (!InventoryUtils.hasRoomForStack(tile, stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<TileEntity> getAdjacentItemStorageTilesWithSpace(TileEntity te, ItemStack stack) {
        ArrayList tileList = Lists.newArrayList();
        for (TileEntity tile : TileEntityUtils.getAdjacentItemStorageTiles(te)) {
            if (!InventoryUtils.hasRoomForStack(tile, stack) || tileList.contains(tile)) continue;
            tileList.add(tile);
        }
        return tileList;
    }

    public static List<TileEntity> getAdjacentFETiles(TileEntity te) {
        return TileEntityUtils.getAdjacentFETiles(te, false);
    }

    public static List<TileEntity> getAdjacentHorizontalFETiles(TileEntity te) {
        return TileEntityUtils.getAdjacentFETiles(te, true);
    }

    private static List<TileEntity> getAdjacentFETiles(TileEntity te, boolean horizontal) {
        ArrayList tileList = Lists.newArrayList();
        for (EnumFacing facing : horizontal ? EnumFacing.HORIZONTALS : EnumFacing.VALUES) {
            if (te == null || te.getWorld() == null || te.getPos() == null) break;
            BlockPos pos = te.getPos();
            TileEntity currentTile = te.getWorld().getTileEntity(pos.offset(facing));
            if (currentTile == null || !currentTile.hasCapability(CapabilityEnergy.ENERGY, facing.getOpposite()) && !currentTile.hasCapability(CapabilityEnergy.ENERGY, null)) continue;
            tileList.add(currentTile);
        }
        return tileList;
    }
}

