/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.apache.commons.lang3.StringUtils;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.BookLoadException;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.ItemStackData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.Textures;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextElement;

public class ContentCrafting
extends PageContent {
    public static final transient int TEX_SIZE = 256;
    public static final transient ImageData IMG_CRAFTING_LARGE = new ImageData(Textures.TEX_CRAFTING, 0, 0, 183, 114, 256, 256);
    public static final transient ImageData IMG_CRAFTING_SMALL = new ImageData(Textures.TEX_CRAFTING, 0, 114, 155, 78, 256, 256);
    public static final transient int X_RESULT_SMALL = 118;
    public static final transient int Y_RESULT_SMALL = 23;
    public static final transient int X_RESULT_LARGE = 146;
    public static final transient int Y_RESULT_LARGE = 41;
    public static final transient float ITEM_SCALE = 2.0f;
    public static final transient int SLOT_MARGIN = 5;
    public static final transient int SLOT_PADDING = 4;
    public String title = "Crafting";
    public String grid_size = "large";
    public ItemStackData[][] grid;
    public ItemStackData result;
    public TextData[] description;
    public String recipe;

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int x = 0;
        int y = 16;
        int height = 100;
        int resultX = 100;
        int resultY = 50;
        TextData tdTitle = new TextData(this.title);
        tdTitle.underlined = true;
        list.add(new TextElement(0, 0, BookScreen.PAGE_WIDTH, 9, tdTitle));
        if (this.grid_size.equalsIgnoreCase("small")) {
            x = BookScreen.PAGE_WIDTH / 2 - ContentCrafting.IMG_CRAFTING_SMALL.width / 2;
            height = y + ContentCrafting.IMG_CRAFTING_SMALL.height;
            list.add(new ImageElement(x, y, ContentCrafting.IMG_CRAFTING_SMALL.width, ContentCrafting.IMG_CRAFTING_SMALL.height, IMG_CRAFTING_SMALL, book.appearance.slotColor));
            resultX = x + 118;
            resultY = y + 23;
        } else if (this.grid_size.equalsIgnoreCase("large")) {
            x = BookScreen.PAGE_WIDTH / 2 - ContentCrafting.IMG_CRAFTING_LARGE.width / 2;
            height = y + ContentCrafting.IMG_CRAFTING_LARGE.height;
            list.add(new ImageElement(x, y, ContentCrafting.IMG_CRAFTING_LARGE.width, ContentCrafting.IMG_CRAFTING_LARGE.height, IMG_CRAFTING_LARGE, book.appearance.slotColor));
            resultX = x + 146;
            resultY = y + 41;
        }
        if (this.grid != null) {
            for (int i = 0; i < this.grid.length; ++i) {
                for (int j = 0; j < this.grid[i].length; ++j) {
                    if (this.grid[i][j] == null || this.grid[i][j].getItems().isEmpty()) continue;
                    list.add(new ItemElement(x + 5 + (4 + Math.round(32.0f)) * j, y + 5 + (4 + Math.round(32.0f)) * i, 2.0f, (Collection<ItemStack>)this.grid[i][j].getItems(), this.grid[i][j].action));
                }
            }
        }
        if (this.result != null) {
            list.add(new ItemElement(resultX, resultY, 2.0f, (Collection<ItemStack>)this.result.getItems(), this.result.action));
        }
        if (this.description != null && this.description.length > 0) {
            list.add(new TextElement(0, height + 5, BookScreen.PAGE_WIDTH, BookScreen.PAGE_HEIGHT - height - 5, this.description));
        }
    }

    @Override
    public void load() {
        super.load();
        if (!StringUtils.isEmpty((CharSequence)this.recipe) && ResourceLocation.func_217855_b((String)this.recipe)) {
            int w = 0;
            int h = 0;
            switch (this.grid_size.toLowerCase()) {
                case "large": {
                    h = 3;
                    w = 3;
                    break;
                }
                case "small": {
                    h = 2;
                    w = 2;
                }
            }
            IRecipe recipe = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(new ResourceLocation(this.recipe)).orElse(null);
            if (recipe instanceof ICraftingRecipe) {
                if (!recipe.func_194133_a(w, h)) {
                    throw new BookLoadException("Recipe " + this.recipe + " cannot fit in a " + w + "x" + h + " crafting grid");
                }
                this.result = ItemStackData.getItemStackData(recipe.func_77571_b());
                NonNullList ingredients = recipe.func_192400_c();
                if (recipe instanceof IShapedRecipe) {
                    IShapedRecipe shaped = (IShapedRecipe)recipe;
                    this.grid = new ItemStackData[shaped.getRecipeHeight()][shaped.getRecipeWidth()];
                    for (int y = 0; y < this.grid.length; ++y) {
                        for (int x = 0; x < this.grid[y].length; ++x) {
                            this.grid[y][x] = ItemStackData.getItemStackData((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])((Ingredient)ingredients.get(x + y * this.grid[y].length)).func_193365_a()));
                        }
                    }
                    return;
                }
                this.grid = new ItemStackData[h][w];
                for (int i = 0; i < ingredients.size(); ++i) {
                    this.grid[i / h][i % w] = ItemStackData.getItemStackData((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])((Ingredient)ingredients.get(i)).func_193365_a()));
                }
            }
        }
    }
}

