/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.render.RenderingHelper;
import slimeknights.mantle.client.screen.book.BookScreen;

@OnlyIn(value=Dist.CLIENT)
public class TextDataRenderer {
    @Nullable
    public static String drawText(MatrixStack matrixStack, int x, int y, int boxWidth, int boxHeight, TextData[] data, int mouseX, int mouseY, FontRenderer fr) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        String action = TextDataRenderer.drawText(matrixStack, x, y, boxWidth, boxHeight, data, mouseX, mouseY, fr, tooltip);
        if (tooltip.size() > 0) {
            TextDataRenderer.drawTooltip(matrixStack, tooltip, mouseX, mouseY, fr);
        }
        return action;
    }

    @Nullable
    public static String drawText(MatrixStack matrixStack, int x, int y, int boxWidth, int boxHeight, TextData[] data, int mouseX, int mouseY, FontRenderer fr, List<ITextComponent> tooltip) {
        String action = "";
        int atX = x;
        int atY = y;
        float prevScale = 1.0f;
        for (TextData item : data) {
            int box1W = 9999;
            fr.getClass();
            int box1H = y + 9;
            int box2Y = 9999;
            int box3X = 9999;
            int box3Y = 9999;
            if (item == null || item.text == null || item.text.isEmpty()) continue;
            if (item.text.equals("\n")) {
                atX = x;
                fr.getClass();
                atY += 9;
                continue;
            }
            if (item.paragraph) {
                atX = x;
                float f = atY;
                fr.getClass();
                atY = (int)(f + (float)(9 * 2) * prevScale);
            }
            prevScale = item.scale;
            String modifiers = "";
            modifiers = modifiers + TextFormatting.func_96300_b((String)item.color);
            if (item.bold) {
                modifiers = modifiers + TextFormatting.BOLD;
            }
            if (item.italic) {
                modifiers = modifiers + TextFormatting.ITALIC;
            }
            if (item.underlined) {
                modifiers = modifiers + TextFormatting.UNDERLINE;
            }
            if (item.strikethrough) {
                modifiers = modifiers + TextFormatting.STRIKETHROUGH;
            }
            if (item.obfuscated) {
                modifiers = modifiers + TextFormatting.OBFUSCATED;
            }
            String text = TextDataRenderer.translateString(item.text);
            String[] split = TextDataRenderer.cropStringBySize(text, modifiers, boxWidth, boxHeight - (atY - y), boxWidth - (atX - x), fr, item.scale);
            int box1X = atX;
            int box1Y = atY;
            int box2X = x;
            int box2W = x + boxWidth;
            for (int i = 0; i < split.length; ++i) {
                if (i == split.length - 1) {
                    box3X = atX;
                    box3Y = atY;
                }
                String s = split[i];
                TextDataRenderer.drawScaledString(matrixStack, fr, modifiers + s, atX, atY, 0, item.dropshadow, item.scale);
                if (i < split.length - 1) {
                    fr.getClass();
                    atY += 9;
                    atX = x;
                }
                if (i != 0) continue;
                box2Y = atY;
                box1W = atX == x ? x + boxWidth : atX;
            }
            int box2H = atY;
            if ((atX = (int)((float)atX + (float)fr.func_78256_a(split[split.length - 1]) * item.scale)) - x >= boxWidth) {
                atX = x;
                float f = atY;
                fr.getClass();
                atY = (int)(f + 9.0f * item.scale);
            }
            int box3W = atX;
            float f = atY;
            fr.getClass();
            int box3H = (int)(f + 9.0f * item.scale);
            if (item.tooltip != null && item.tooltip.length > 0 && (mouseX >= box1X && mouseX <= box1W && mouseY >= box1Y && mouseY <= box1H && box1X != box1W && box1Y != box1H || mouseX >= box2X && mouseX <= box2W && mouseY >= box2Y && mouseY <= box2H && box2X != box2W && box2Y != box2H || mouseX >= box3X && mouseX <= box3W && mouseY >= box3Y && mouseY <= box3H && box3X != box3W && box1Y != box3H)) {
                tooltip.addAll(Arrays.asList(item.tooltip));
            }
            if (item.action != null && !item.action.isEmpty() && (mouseX >= box1X && mouseX <= box1W && mouseY >= box1Y && mouseY <= box1H && box1X != box1W && box1Y != box1H || mouseX >= box2X && mouseX <= box2W && mouseY >= box2Y && mouseY <= box2H && box2X != box2W && box2Y != box2H || mouseX >= box3X && mouseX <= box3W && mouseY >= box3Y && mouseY <= box3H && box3X != box3W && box1Y != box3H)) {
                action = item.action;
            }
            if (atY >= y + boxHeight) {
                if (item.dropshadow) {
                    fr.func_238405_a_(matrixStack, "...", (float)atX, (float)atY, 0);
                    break;
                }
                fr.func_238421_b_(matrixStack, "...", (float)atX, (float)atY, 0);
                break;
            }
            y = atY;
        }
        if (BookScreen.debug && action != null && !action.isEmpty()) {
            tooltip.add(StringTextComponent.field_240750_d_);
            tooltip.add((ITextComponent)new StringTextComponent("Action: " + action).func_240699_a_(TextFormatting.GRAY));
        }
        return action;
    }

    public static String translateString(String s) {
        s = s.replace("$$(", "$\u0000(").replace(")$$", ")\u0000$");
        while (s.contains("$(") && s.contains(")$") && s.indexOf("$(") < s.indexOf(")$")) {
            String loc = s.substring(s.indexOf("$(") + 2, s.indexOf(")$"));
            s = s.replace("$(" + loc + ")$", I18n.func_135052_a((String)loc, (Object[])new Object[0]));
        }
        if (s.indexOf("$(") > s.indexOf(")$") || s.contains(")$")) {
            Mantle.logger.error("[Books] [TextDataRenderer] Detected unbalanced localization symbols \"$(\" and \")$\" in string: \"" + s + "\".");
        }
        return s.replace("$\u0000(", "$(").replace(")\u0000$", ")$");
    }

    public static String[] cropStringBySize(String s, String modifiers, int width, int height, FontRenderer fr, float scale) {
        return TextDataRenderer.cropStringBySize(s, modifiers, width, height, width, fr, scale);
    }

    public static String[] cropStringBySize(String s, String modifiers, int width, int height, int firstWidth, FontRenderer fr, float scale) {
        int curWidth = 0;
        fr.getClass();
        int curHeight = (int)(9.0f * scale);
        for (int i = 0; i < s.length(); ++i) {
            curWidth = (int)((float)curWidth + (float)fr.func_78256_a(modifiers + s.charAt(i)) * scale);
            if (s.charAt(i) != '\n') {
                fr.getClass();
                if (curHeight != (int)(9.0f * scale) || curWidth <= firstWidth) {
                    fr.getClass();
                    if (curHeight == (int)(9.0f * scale) || curWidth <= width) continue;
                }
            }
            int oldI = i;
            while (i >= 0 && s.charAt(i) != ' ') {
                --i;
            }
            if (i <= 0) {
                i = oldI;
            }
            s = s.substring(0, i) + "\r" + StringUtils.stripStart((String)s.substring(i + (i == oldI ? 0 : 1)), (String)" ");
            ++i;
            curWidth = 0;
            float f = curHeight;
            fr.getClass();
            curHeight = (int)(f + 9.0f * scale);
            if (curHeight < height) continue;
            return s.substring(0, i).split("\r");
        }
        return s.split("\r");
    }

    public static void drawTooltip(MatrixStack matrixStack, List<ITextComponent> textLines, int mouseX, int mouseY, FontRenderer font) {
        RenderingHelper.drawHoveringText(matrixStack, textLines, mouseX, mouseY, BookScreen.PAGE_WIDTH, BookScreen.PAGE_HEIGHT, BookScreen.PAGE_WIDTH, font);
        RenderHelper.func_74518_a();
    }

    public static void drawScaledString(MatrixStack matrixStack, FontRenderer font, String text, float x, float y, int color, boolean dropShadow, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        if (dropShadow) {
            font.func_238405_a_(matrixStack, text, 0.0f, 0.0f, color);
        } else {
            font.func_238421_b_(matrixStack, text, 0.0f, 0.0f, color);
        }
        RenderSystem.popMatrix();
    }

    private static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_225582_a_((double)right, (double)top, 0.0).func_227885_a_(f1, f2, f3, f).func_181675_d();
        vertexBuffer.func_225582_a_((double)left, (double)top, 0.0).func_227885_a_(f1, f2, f3, f).func_181675_d();
        vertexBuffer.func_225582_a_((double)left, (double)bottom, 0.0).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        vertexBuffer.func_225582_a_((double)right, (double)bottom, 0.0).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }
}

