/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractRecipeBuilder<T extends AbstractRecipeBuilder<T>> {
    protected final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    @Nonnull
    protected String group = "";

    public T addCriterion(String name, ICriterionInstance criteria) {
        this.advancementBuilder.func_200275_a(name, criteria);
        return (T)this;
    }

    public T setGroup(String group) {
        this.group = group;
        return (T)this;
    }

    public T setGroup(ResourceLocation group) {
        if ("minecraft".equals(group.func_110624_b())) {
            return this.setGroup(group.func_110623_a());
        }
        return this.setGroup(group.toString());
    }

    public abstract void build(Consumer<IFinishedRecipe> var1);

    public abstract void build(Consumer<IFinishedRecipe> var1, ResourceLocation var2);

    protected ResourceLocation buildAdvancement(ResourceLocation id, String folder) {
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        return new ResourceLocation(id.func_110624_b(), "recipes/" + folder + "/" + id.func_110623_a());
    }
}

